# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_teamtype_global_optspecs
	string join \n directory= h/help V/version
end

function __fish_teamtype_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_teamtype_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_teamtype_using_subcommand
	set -l cmd (__fish_teamtype_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c teamtype -n "__fish_teamtype_needs_command" -l directory -d 'The shared directory. Defaults to current directory' -r -F
complete -c teamtype -n "__fish_teamtype_needs_command" -s h -l help -d 'Print help'
complete -c teamtype -n "__fish_teamtype_needs_command" -s V -l version -d 'Print version'
complete -c teamtype -n "__fish_teamtype_needs_command" -f -a "share" -d 'Share a directory with a new peer'
complete -c teamtype -n "__fish_teamtype_needs_command" -f -a "join" -d 'Join a shared directory via a join code, or connect to the most recent one'
complete -c teamtype -n "__fish_teamtype_needs_command" -f -a "client" -d 'Open a JSON-RPC connection to the Teamtype daemon on stdin/stdout. Used by text editor plugins'
complete -c teamtype -n "__fish_teamtype_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c teamtype -n "__fish_teamtype_using_subcommand share" -l directory -d 'The shared directory. Defaults to current directory' -r -F
complete -c teamtype -n "__fish_teamtype_using_subcommand share" -l init -d 'Re-initialize the history of the shared directory. You will loose previous history'
complete -c teamtype -n "__fish_teamtype_using_subcommand share" -l no-join-code -d 'Do not generate a join code. To prevent unintended sharing or simply if you want to keep Magic Wormhole out of the loop'
complete -c teamtype -n "__fish_teamtype_using_subcommand share" -l show-secret-address -d 'Print the secret address. Useful for sharing with multiple people'
complete -c teamtype -n "__fish_teamtype_using_subcommand share" -l sync-vcs -d 'EXPERIMENTAL: Also synchronize version-control directories like .git/ or .jj/, which are normally ignored. For Git, this will synchronize all branches, commits, etc. as well as your .git/config. This means that new commits will immediately appear at all peers, you can change branches together, etc'
complete -c teamtype -n "__fish_teamtype_using_subcommand share" -s h -l help -d 'Print help'
complete -c teamtype -n "__fish_teamtype_using_subcommand share" -s V -l version -d 'Print version'
complete -c teamtype -n "__fish_teamtype_using_subcommand join" -l directory -d 'The shared directory. Defaults to current directory' -r -F
complete -c teamtype -n "__fish_teamtype_using_subcommand join" -l sync-vcs -d 'EXPERIMENTAL: Also synchronize version-control directories like .git/ or .jj/, which are normally ignored. For Git, this will synchronize all branches, commits, etc. as well as your .git/config. This means that new commits will immediately appear at all peers, you can change branches together, etc'
complete -c teamtype -n "__fish_teamtype_using_subcommand join" -s h -l help -d 'Print help'
complete -c teamtype -n "__fish_teamtype_using_subcommand join" -s V -l version -d 'Print version'
complete -c teamtype -n "__fish_teamtype_using_subcommand client" -l directory -d 'The shared directory. Defaults to current directory' -r -F
complete -c teamtype -n "__fish_teamtype_using_subcommand client" -s h -l help -d 'Print help'
complete -c teamtype -n "__fish_teamtype_using_subcommand client" -s V -l version -d 'Print version'
complete -c teamtype -n "__fish_teamtype_using_subcommand help; and not __fish_seen_subcommand_from share join client help" -f -a "share" -d 'Share a directory with a new peer'
complete -c teamtype -n "__fish_teamtype_using_subcommand help; and not __fish_seen_subcommand_from share join client help" -f -a "join" -d 'Join a shared directory via a join code, or connect to the most recent one'
complete -c teamtype -n "__fish_teamtype_using_subcommand help; and not __fish_seen_subcommand_from share join client help" -f -a "client" -d 'Open a JSON-RPC connection to the Teamtype daemon on stdin/stdout. Used by text editor plugins'
complete -c teamtype -n "__fish_teamtype_using_subcommand help; and not __fish_seen_subcommand_from share join client help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
