/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.ShapeDocValues;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.SpatialQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Geometry;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;

abstract class BaseShapeDocValuesQuery
extends SpatialQuery {
    BaseShapeDocValuesQuery(String field, ShapeField.QueryRelation queryRelation, Geometry ... geometries) {
        super(field, BaseShapeDocValuesQuery.validateRelation(queryRelation), geometries);
    }

    private static ShapeField.QueryRelation validateRelation(ShapeField.QueryRelation queryRelation) {
        if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
            throw new IllegalArgumentException("ShapeDocValuesBoundingBoxQuery does not yet support CONTAINS queries");
        }
        return queryRelation;
    }

    protected abstract ShapeDocValues getShapeDocValues(BytesRef var1);

    @Override
    protected ScorerSupplier getScorerSupplier(final LeafReader reader, SpatialQuery.SpatialVisitor spatialVisitor, final ScoreMode scoreMode, final ConstantScoreWeight weight, final float boost, float score) throws IOException {
        final BinaryDocValues values = reader.getBinaryDocValues(this.field);
        if (values == null) {
            return null;
        }
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(this.field);
        if (fieldInfo == null) {
            return null;
        }
        final TwoPhaseIterator iterator = new TwoPhaseIterator(values){

            @Override
            public boolean matches() throws IOException {
                return BaseShapeDocValuesQuery.this.match(BaseShapeDocValuesQuery.this.getShapeDocValues(values.binaryValue()));
            }

            @Override
            public float matchCost() {
                return BaseShapeDocValuesQuery.this.matchCost();
            }
        };
        return new ScorerSupplier(){

            @Override
            public Scorer get(long leadCost) {
                return new ConstantScoreScorer((Weight)weight, boost, scoreMode, iterator);
            }

            @Override
            public long cost() {
                return reader.maxDoc();
            }
        };
    }

    protected boolean match(ShapeDocValues shapeDocValues) throws IOException {
        boolean result = this.matchesComponent(shapeDocValues, this.queryRelation, this.queryComponent2D);
        if (this.queryRelation == ShapeField.QueryRelation.DISJOINT) {
            return !result;
        }
        return result;
    }

    protected float matchCost() {
        return 6000.0f;
    }

    protected boolean matchesComponent(ShapeDocValues dv, ShapeField.QueryRelation queryRelation, Component2D component) throws IOException {
        PointValues.Relation r = dv.relate(component);
        if (r != PointValues.Relation.CELL_OUTSIDE_QUERY) {
            if (queryRelation == ShapeField.QueryRelation.WITHIN) {
                return r == PointValues.Relation.CELL_INSIDE_QUERY;
            }
            return true;
        }
        return false;
    }
}

