/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class JpsMavenRepositoryLibraryDescriptor {
    public static final String DEFAULT_PACKAGING = "jar";
    private final String myMavenId;
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myPackaging;
    private final boolean myIncludeTransitiveDependencies;
    private final List<String> myExcludedDependencies;
    private final String myJarRepositoryId;
    private final List<ArtifactVerification> myArtifactsVerification;

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(1);
        }
        if (version == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(2);
        }
        this(groupId, artifactId, version, true, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        if (groupId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(4);
        }
        if (version == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(5);
        }
        if (excludedDependencies == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(6);
        }
        this(groupId, artifactId, version, DEFAULT_PACKAGING, includeTransitiveDependencies, excludedDependencies);
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String packaging, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        if (groupId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(7);
        }
        if (artifactId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(8);
        }
        if (version == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(9);
        }
        if (packaging == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(10);
        }
        if (excludedDependencies == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(11);
        }
        this(groupId, artifactId, version, packaging, includeTransitiveDependencies, excludedDependencies, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String packaging, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies, @NotNull List<ArtifactVerification> metadata) {
        if (groupId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(12);
        }
        if (artifactId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(13);
        }
        if (version == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(14);
        }
        if (packaging == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(15);
        }
        if (excludedDependencies == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(16);
        }
        if (metadata == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(17);
        }
        this(groupId, artifactId, version, packaging, includeTransitiveDependencies, excludedDependencies, metadata, null);
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String packaging, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies, @NotNull List<ArtifactVerification> metadata, @Nullable String jarRepositoryId) {
        if (groupId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(18);
        }
        if (artifactId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(19);
        }
        if (version == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(20);
        }
        if (packaging == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(21);
        }
        if (excludedDependencies == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(22);
        }
        if (metadata == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(23);
        }
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myPackaging = packaging;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        this.myExcludedDependencies = excludedDependencies;
        this.myMavenId = groupId + ":" + artifactId + ":" + version;
        this.myArtifactsVerification = metadata;
        this.myJarRepositoryId = jarRepositoryId;
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId) {
        this(mavenId, true, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies) {
        if (groupId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(24);
        }
        if (artifactId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(25);
        }
        if (version == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(26);
        }
        this(groupId, artifactId, version, includeTransitiveDependencies, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this(mavenId, DEFAULT_PACKAGING, includeTransitiveDependencies, excludedDependencies);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, @NotNull String packaging, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        if (packaging == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(27);
        }
        this(mavenId, packaging, includeTransitiveDependencies, excludedDependencies, Collections.emptyList(), null);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, boolean includeTransitiveDependencies, List<String> excludedDependencies, @NotNull List<ArtifactVerification> artifactsVerification, @Nullable String jarRepositoryId) {
        if (artifactsVerification == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(28);
        }
        this(mavenId, DEFAULT_PACKAGING, includeTransitiveDependencies, excludedDependencies, artifactsVerification, jarRepositoryId);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, @NotNull String packaging, boolean includeTransitiveDependencies, List<String> excludedDependencies, @NotNull List<ArtifactVerification> artifactsVerification, @Nullable String jarRepositoryId) {
        if (packaging == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(29);
        }
        if (artifactsVerification == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(30);
        }
        this.myMavenId = mavenId;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        this.myExcludedDependencies = excludedDependencies;
        this.myPackaging = packaging;
        this.myArtifactsVerification = artifactsVerification;
        this.myJarRepositoryId = jarRepositoryId;
        if (mavenId == null) {
            this.myVersion = null;
            this.myArtifactId = null;
            this.myGroupId = null;
        } else {
            String[] parts = mavenId.split(":");
            this.myGroupId = parts.length > 0 ? parts[0] : null;
            this.myArtifactId = parts.length > 1 ? parts[1] : null;
            this.myVersion = parts.length > 2 ? parts[2] : null;
        }
    }

    public String getMavenId() {
        return this.myMavenId;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.myIncludeTransitiveDependencies;
    }

    public List<String> getExcludedDependencies() {
        return this.myExcludedDependencies;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getPackaging() {
        return this.myPackaging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpsMavenRepositoryLibraryDescriptor that = (JpsMavenRepositoryLibraryDescriptor)o;
        return this.myIncludeTransitiveDependencies == that.myIncludeTransitiveDependencies && this.myMavenId.equals(that.myMavenId) && this.myPackaging.equals(that.myPackaging) && this.myExcludedDependencies.equals(that.myExcludedDependencies) && this.myArtifactsVerification.equals(that.myArtifactsVerification) && Objects.equals(this.myJarRepositoryId, that.myJarRepositoryId);
    }

    public int hashCode() {
        return Objects.hash(this.myMavenId, this.myPackaging, this.myIncludeTransitiveDependencies, this.myExcludedDependencies, this.myArtifactsVerification, this.myJarRepositoryId);
    }

    public String toString() {
        return this.myMavenId != null ? this.myMavenId : "null";
    }

    public boolean isVerifySha256Checksum() {
        return ContainerUtil.exists(this.myArtifactsVerification, it -> it.getSha256sum() != null);
    }

    public List<ArtifactVerification> getArtifactsVerification() {
        return this.myArtifactsVerification;
    }

    public String getJarRepositoryId() {
        return this.myJarRepositoryId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "groupId";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 19: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[0] = "artifactId";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 20: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[0] = "version";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[0] = "excludedDependencies";
                break;
            }
            case 10: 
            case 15: 
            case 21: 
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[0] = "packaging";
                break;
            }
            case 17: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[0] = "metadata";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[0] = "artifactsVerification";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ArtifactVerification {
        private final String url;
        private final String sha256sum;

        public ArtifactVerification(@NotNull String url, @NotNull String sha256sum) {
            if (url == null) {
                ArtifactVerification.$$$reportNull$$$0(0);
            }
            if (sha256sum == null) {
                ArtifactVerification.$$$reportNull$$$0(1);
            }
            this.url = url;
            this.sha256sum = sha256sum;
        }

        public String getSha256sum() {
            return this.sha256sum;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactVerification that = (ArtifactVerification)o;
            return Objects.equals(this.url, that.url) && Objects.equals(this.sha256sum, that.sha256sum);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.sha256sum);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sha256sum";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor$ArtifactVerification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

