/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    /*
     * WARNING - void declaration
     */
    public ByteVector(int initialCapacity) {
        void var1_1;
        this.data = new byte[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    ByteVector(byte[] data) {
        void var1_1;
        this.data = data;
        this.length = ((void)var1_1).length;
    }

    public int size() {
        return this.length;
    }

    /*
     * WARNING - void declaration
     */
    public ByteVector putByte(int byteValue) {
        void var2_2;
        void var1_1;
        int currentLength = this.length;
        if (currentLength + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[currentLength++] = (byte)var1_1;
        this.length = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final ByteVector put11(int byteValue1, int byteValue2) {
        void var3_3;
        void var2_2;
        void var1_1;
        int currentLength = this.length;
        if (currentLength + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] currentData = this.data;
        this.data[currentLength++] = (byte)var1_1;
        currentData[currentLength++] = (byte)var2_2;
        this.length = var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ByteVector putShort(int shortValue) {
        void var2_2;
        void var1_1;
        int currentLength = this.length;
        if (currentLength + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] currentData = this.data;
        this.data[currentLength++] = (byte)(shortValue >>> 8);
        var3_3[currentLength++] = (byte)var1_1;
        this.length = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final ByteVector put12(int byteValue, int shortValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        int currentLength = this.length;
        if (currentLength + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] currentData = this.data;
        this.data[currentLength++] = (byte)var1_1;
        currentData[currentLength++] = (byte)(shortValue >>> 8);
        currentData[currentLength++] = (byte)var2_2;
        this.length = var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final ByteVector put112(int byteValue1, int byteValue2, int shortValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        int currentLength = this.length;
        if (currentLength + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] currentData = this.data;
        this.data[currentLength++] = (byte)var1_1;
        currentData[currentLength++] = (byte)var2_2;
        currentData[currentLength++] = (byte)(shortValue >>> 8);
        currentData[currentLength++] = (byte)var3_3;
        this.length = currentLength;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ByteVector putInt(int intValue) {
        void var2_2;
        void var1_1;
        int currentLength = this.length;
        if (currentLength + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] currentData = this.data;
        this.data[currentLength++] = (byte)(intValue >>> 24);
        currentData[currentLength++] = (byte)(intValue >>> 16);
        currentData[currentLength++] = (byte)(intValue >>> 8);
        var3_3[currentLength++] = (byte)var1_1;
        this.length = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final ByteVector put122(int byteValue, int shortValue1, int shortValue2) {
        void var3_3;
        void var2_2;
        void var1_1;
        int currentLength = this.length;
        if (currentLength + 5 > this.data.length) {
            this.enlarge(5);
        }
        byte[] currentData = this.data;
        this.data[currentLength++] = (byte)var1_1;
        currentData[currentLength++] = (byte)(shortValue1 >>> 8);
        currentData[currentLength++] = (byte)var2_2;
        currentData[currentLength++] = (byte)(shortValue2 >>> 8);
        currentData[currentLength++] = (byte)var3_3;
        this.length = currentLength;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ByteVector putLong(long longValue) {
        void var3_2;
        void var1_1;
        int currentLength = this.length;
        if (currentLength + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] currentData = this.data;
        int intValue = (int)(longValue >>> 32);
        currentData[currentLength++] = (byte)(intValue >>> 24);
        currentData[currentLength++] = (byte)(intValue >>> 16);
        currentData[currentLength++] = (byte)(intValue >>> 8);
        currentData[currentLength++] = (byte)intValue;
        intValue = (int)var1_1;
        currentData[currentLength++] = (byte)(intValue >>> 24);
        currentData[currentLength++] = (byte)(intValue >>> 16);
        currentData[currentLength++] = (byte)(intValue >>> 8);
        currentData[currentLength++] = (byte)intValue;
        this.length = var3_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ByteVector putUTF8(String stringValue) {
        void var3_3;
        int charLength = stringValue.length();
        if (charLength > 65535) {
            throw new IllegalArgumentException("UTF8 string too large");
        }
        int currentLength = this.length;
        if (currentLength + 2 + charLength > this.data.length) {
            this.enlarge(charLength + 2);
        }
        byte[] currentData = this.data;
        this.data[currentLength++] = (byte)(charLength >>> 8);
        currentData[currentLength++] = (byte)charLength;
        for (int i = 0; i < charLength; ++i) {
            char charValue = stringValue.charAt(i);
            if (charValue <= '\u0000' || charValue > '\u007f') {
                this.length = currentLength;
                return this.encodeUtf8(stringValue, i, 65535);
            }
            currentData[currentLength++] = (byte)charValue;
        }
        this.length = var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final ByteVector encodeUtf8(String stringValue, int offset, int maxByteLength) {
        void i;
        int charLength = stringValue.length();
        int byteLength = offset;
        for (int i2 = offset; i2 < charLength; ++i2) {
            char charValue = stringValue.charAt(i2);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                ++byteLength;
                continue;
            }
            if (charValue <= '\u07ff') {
                byteLength += 2;
                continue;
            }
            byteLength += 3;
        }
        if (byteLength > maxByteLength) {
            throw new IllegalArgumentException("UTF8 string too large");
        }
        int byteLengthOffset = this.length - offset - 2;
        if (byteLengthOffset >= 0) {
            this.data[byteLengthOffset] = (byte)(byteLength >>> 8);
            this.data[byteLengthOffset + 1] = (byte)byteLength;
        }
        if (this.length + byteLength - offset > this.data.length) {
            this.enlarge(byteLength - offset);
        }
        int currentLength = this.length;
        while (i < charLength) {
            char charValue = stringValue.charAt((int)i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                this.data[currentLength++] = (byte)charValue;
            } else if (charValue <= '\u07ff') {
                this.data[currentLength++] = (byte)(0xC0 | charValue >> 6 & 0x1F);
                this.data[currentLength++] = (byte)(0x80 | charValue & 0x3F);
            } else {
                void var3_3;
                this.data[currentLength++] = (byte)(0xE0 | charValue >> 12 & 0xF);
                this.data[currentLength++] = (byte)(0x80 | charValue >> 6 & 0x3F);
                this.data[currentLength++] = (byte)(0x80 | var3_3 & 0x3F);
            }
            ++i;
        }
        this.length = currentLength;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ByteVector putByteArray(byte[] byteArrayValue, int byteOffset, int byteLength) {
        void var3_3;
        if (this.length + byteLength > this.data.length) {
            this.enlarge(byteLength);
        }
        if (byteArrayValue != null) {
            void var2_2;
            void var1_1;
            System.arraycopy(var1_1, (int)var2_2, this.data, this.length, byteLength);
        }
        this.length += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void enlarge(int size) {
        void var1_2;
        int n;
        if (this.length > this.data.length) {
            throw new AssertionError((Object)"Internal error");
        }
        int doubleCapacity = 2 * this.data.length;
        int minimalCapacity = this.length + size;
        byte[] newData = new byte[doubleCapacity > minimalCapacity ? n : minimalCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = var1_2;
    }
}

