/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.hierarchy.types;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hierarchy/types/KotlinTypeHierarchyNodeDescriptor;", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "parentDescriptor", "classOrFunctionalExpression", "Lcom/intellij/psi/PsiElement;", "isBase", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;Lcom/intellij/psi/PsiElement;Z)V", "update", "Companion", "kotlin.code-insight.k2"})
public final class KotlinTypeHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KotlinTypeHierarchyNodeDescriptor(@NotNull Project project, @Nullable HierarchyNodeDescriptor parentDescriptor, @NotNull PsiElement classOrFunctionalExpression, boolean isBase) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)classOrFunctionalExpression, (String)"classOrFunctionalExpression");
        super(project, (NodeDescriptor)parentDescriptor, classOrFunctionalExpression, isBase);
    }

    public boolean update() {
        boolean changes = super.update();
        if (this.getPsiElement() == null) {
            return this.invalidElement();
        }
        if (changes && this.myIsBase) {
            this.setIcon(this.getBaseMarkerIcon(this.getIcon()));
        }
        PsiElement psiElement = this.getPsiElement();
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance, (String)"myHighlightedText");
        CompositeAppearance oldText = compositeAppearance;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (psiElement instanceof KtClassOrObject) {
            TargetPresentation targetPresentation = GotoTargetHandler.computePresentation((PsiElement)psiElement, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"computePresentation(...)");
            TargetPresentation targetPresentation2 = targetPresentation;
            this.myHighlightedText.getEnding().addText(targetPresentation2.getPresentableText(), classNameAttributes);
            CompositeAppearance.DequeEnd dequeEnd = this.myHighlightedText.getEnding();
            String string = targetPresentation2.getContainerText();
            if (string == null) {
                string = "";
            }
            dequeEnd.addText(" (" + string + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hierarchy/types/KotlinTypeHierarchyNodeDescriptor$Companion;", "", "<init>", "()V", "createTypeHierarchyDescriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "klass", "Lcom/intellij/psi/PsiElement;", "descriptor", "kotlin.code-insight.k2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HierarchyNodeDescriptor createTypeHierarchyDescriptor(@NotNull PsiElement klass, @Nullable HierarchyNodeDescriptor descriptor2) {
            HierarchyNodeDescriptor hierarchyNodeDescriptor;
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            if (klass instanceof KtClassOrObject) {
                Project project = ((KtClassOrObject)klass).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                hierarchyNodeDescriptor = new KotlinTypeHierarchyNodeDescriptor(project, descriptor2, klass, false);
            } else {
                hierarchyNodeDescriptor = (HierarchyNodeDescriptor)new TypeHierarchyNodeDescriptor(klass.getProject(), descriptor2, klass, false);
            }
            return hierarchyNodeDescriptor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

