/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.projectModel;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.DefaultGradleSourceSetModel;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.GradleSourceSetSerialisationService;
import com.intellij.gradle.toolingExtension.impl.model.taskModel.DefaultGradleTaskModel;
import com.intellij.gradle.toolingExtension.impl.model.taskModel.GradleTaskSerialisationService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

@ApiStatus.Internal
public final class GradleExternalProjectSerializationService
implements SerializationService<ExternalProject> {
    private static final String PROJECT_ID_FIELD = "id";
    private static final String PROJECT_PATH_FIELD = "path";
    private static final String PROJECT_IDENTITY_PATH_FIELD = "identityPath";
    private static final String PROJECT_NAME_FIELD = "name";
    private static final String PROJECT_Q_NAME_FIELD = "qName";
    private static final String PROJECT_DESCRIPTION_FIELD = "description";
    private static final String PROJECT_GROUP_FIELD = "group";
    private static final String PROJECT_VERSION_FIELD = "version";
    private static final String PROJECT_DIR_FIELD = "projectDir";
    private static final String PROJECT_BUILD_DIR_FIELD = "buildDir";
    private static final String PROJECT_BUILD_FILE_FIELD = "buildFile";
    private static final String PROJECT_SOURCE_SET_MODEL_FIELD = "sourceSetModel";
    private static final String PROJECT_TASK_MODEL_FIELD = "taskModel";
    private static final String PROJECT_CHILD_PROJECTS_FIELD = "childProjects";
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    public Class<? extends ExternalProject> getModelClass() {
        return ExternalProject.class;
    }

    public byte[] write(ExternalProject project, Class<? extends ExternalProject> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);){
            GradleExternalProjectSerializationService.writeProject(writer, this.myWriteContext, project);
        }
        return out.toByteArray();
    }

    public ExternalProject read(byte[] object, Class<? extends ExternalProject> modelClazz) throws IOException {
        try (IonReader reader = IonReaderBuilder.standard().build(object);){
            DefaultExternalProject defaultExternalProject = GradleExternalProjectSerializationService.readProject(reader, this.myReadContext);
            return defaultExternalProject;
        }
    }

    private static void writeProject(IonWriter writer, WriteContext context, ExternalProject project) throws IOException {
        context.getProjectsCollector().add(project, (isAdded, objectId) -> {
            writer.stepIn(IonType.STRUCT);
            ToolingStreamApiUtils.writeInt(writer, "objectID", objectId);
            if (isAdded) {
                ToolingStreamApiUtils.writeString(writer, PROJECT_ID_FIELD, project.getId());
                ToolingStreamApiUtils.writeString(writer, PROJECT_PATH_FIELD, project.getPath());
                ToolingStreamApiUtils.writeString(writer, PROJECT_IDENTITY_PATH_FIELD, project.getIdentityPath());
                ToolingStreamApiUtils.writeString(writer, PROJECT_NAME_FIELD, project.getName());
                ToolingStreamApiUtils.writeString(writer, PROJECT_Q_NAME_FIELD, project.getQName());
                ToolingStreamApiUtils.writeString(writer, PROJECT_DESCRIPTION_FIELD, project.getDescription());
                ToolingStreamApiUtils.writeString(writer, PROJECT_GROUP_FIELD, project.getGroup());
                ToolingStreamApiUtils.writeString(writer, PROJECT_VERSION_FIELD, project.getVersion());
                ToolingStreamApiUtils.writeString(writer, PROJECT_DIR_FIELD, project.getProjectDir().getPath());
                ToolingStreamApiUtils.writeString(writer, PROJECT_BUILD_DIR_FIELD, project.getBuildDir().getPath());
                ToolingStreamApiUtils.writeFile(writer, PROJECT_BUILD_FILE_FIELD, project.getBuildFile());
                GradleExternalProjectSerializationService.writeSourceSetModel(writer, context, project);
                GradleExternalProjectSerializationService.writeTaskModel(writer, project);
                GradleExternalProjectSerializationService.writeChildProjects(writer, context, project);
            }
            writer.stepOut();
        });
    }

    @Nullable
    private static DefaultExternalProject readProject(final @NotNull IonReader reader, final @NotNull ReadContext context) {
        if (reader == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(1);
        }
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultExternalProject project = (DefaultExternalProject)context.getProjectsMap().computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<DefaultExternalProject>(){

            public DefaultExternalProject newInstance() {
                return new DefaultExternalProject();
            }

            public void fill(DefaultExternalProject externalProject) {
                externalProject.setExternalSystemId("GRADLE");
                externalProject.setId(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, GradleExternalProjectSerializationService.PROJECT_ID_FIELD)));
                externalProject.setPath(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, GradleExternalProjectSerializationService.PROJECT_PATH_FIELD)));
                externalProject.setIdentityPath(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, GradleExternalProjectSerializationService.PROJECT_IDENTITY_PATH_FIELD)));
                externalProject.setName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, GradleExternalProjectSerializationService.PROJECT_NAME_FIELD)));
                externalProject.setQName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, GradleExternalProjectSerializationService.PROJECT_Q_NAME_FIELD)));
                externalProject.setDescription(ToolingStreamApiUtils.readString(reader, GradleExternalProjectSerializationService.PROJECT_DESCRIPTION_FIELD));
                externalProject.setGroup(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, GradleExternalProjectSerializationService.PROJECT_GROUP_FIELD)));
                externalProject.setVersion(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, GradleExternalProjectSerializationService.PROJECT_VERSION_FIELD)));
                externalProject.setProjectDir(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readFile(reader, GradleExternalProjectSerializationService.PROJECT_DIR_FIELD)));
                externalProject.setBuildDir(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readFile(reader, GradleExternalProjectSerializationService.PROJECT_BUILD_DIR_FIELD)));
                externalProject.setBuildFile(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readFile(reader, GradleExternalProjectSerializationService.PROJECT_BUILD_FILE_FIELD)));
                externalProject.setSourceSetModel(GradleExternalProjectSerializationService.readSourceSetModel(reader, context));
                externalProject.setTaskModel(GradleExternalProjectSerializationService.readTaskModel(reader));
                externalProject.setChildProjects(GradleExternalProjectSerializationService.readChildProjects(reader, context));
            }
        });
        reader.stepOut();
        return project;
    }

    private static void writeChildProjects(@NotNull IonWriter writer, @NotNull WriteContext context, @NotNull ExternalProject project) throws IOException {
        if (writer == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(4);
        }
        ToolingStreamApiUtils.writeCollection(writer, PROJECT_CHILD_PROJECTS_FIELD, project.getChildProjects().values(), it -> GradleExternalProjectSerializationService.writeProject(writer, context, it));
    }

    @NotNull
    private static Map<String, DefaultExternalProject> readChildProjects(@NotNull IonReader reader, @NotNull ReadContext context) {
        if (reader == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(6);
        }
        Map<String, DefaultExternalProject> map = ToolingStreamApiUtils.readList(reader, PROJECT_CHILD_PROJECTS_FIELD, () -> GradleExternalProjectSerializationService.readProject(reader, context)).stream().collect(Collectors.toMap(it -> it.getName(), it -> it));
        if (map == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(7);
        }
        return map;
    }

    private static void writeSourceSetModel(@NotNull IonWriter writer, @NotNull WriteContext context, @NotNull ExternalProject project) {
        if (writer == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(10);
        }
        writer.setFieldName(PROJECT_SOURCE_SET_MODEL_FIELD);
        GradleSourceSetSerialisationService.writeSourceSetModel(writer, context.sourceSetModel, project.getSourceSetModel());
    }

    @NotNull
    private static DefaultGradleSourceSetModel readSourceSetModel(@NotNull IonReader reader, @NotNull ReadContext context) {
        if (reader == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(12);
        }
        ToolingStreamApiUtils.assertNotNull(reader.next());
        ToolingStreamApiUtils.assertFieldName(reader, PROJECT_SOURCE_SET_MODEL_FIELD);
        DefaultGradleSourceSetModel defaultGradleSourceSetModel = GradleSourceSetSerialisationService.readSourceSetModel(reader, context.sourceSetModel);
        if (defaultGradleSourceSetModel == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(13);
        }
        return defaultGradleSourceSetModel;
    }

    private static void writeTaskModel(@NotNull IonWriter writer, @NotNull ExternalProject project) {
        if (writer == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(14);
        }
        if (project == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(15);
        }
        writer.setFieldName(PROJECT_TASK_MODEL_FIELD);
        GradleTaskSerialisationService.writeTaskModel(writer, project.getTaskModel());
    }

    @NotNull
    private static DefaultGradleTaskModel readTaskModel(@NotNull IonReader reader) {
        if (reader == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(16);
        }
        ToolingStreamApiUtils.assertNotNull(reader.next());
        ToolingStreamApiUtils.assertFieldName(reader, PROJECT_TASK_MODEL_FIELD);
        DefaultGradleTaskModel defaultGradleTaskModel = GradleTaskSerialisationService.readTaskModel(reader);
        if (defaultGradleTaskModel == null) {
            GradleExternalProjectSerializationService.$$$reportNull$$$0(17);
        }
        return defaultGradleTaskModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/projectModel/GradleExternalProjectSerializationService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/projectModel/GradleExternalProjectSerializationService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readChildProjects";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readSourceSetModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "readTaskModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readProject";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeChildProjects";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readChildProjects";
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeSourceSetModel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readSourceSetModel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeTaskModel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readTaskModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReadContext {
        private final GradleSourceSetSerialisationService.SourceSetModelReadContext sourceSetModel = new GradleSourceSetSerialisationService.SourceSetModelReadContext();
        private final IntObjectMap<DefaultExternalProject> myProjectsMap = new IntObjectMap();

        private ReadContext() {
        }

        public IntObjectMap<DefaultExternalProject> getProjectsMap() {
            return this.myProjectsMap;
        }
    }

    private static class WriteContext {
        private final GradleSourceSetSerialisationService.SourceSetModelWriteContext sourceSetModel = new GradleSourceSetSerialisationService.SourceSetModelWriteContext();
        private final ObjectCollector<ExternalProject, IOException> myProjectsCollector = new ObjectCollector();

        private WriteContext() {
        }

        public ObjectCollector<ExternalProject, IOException> getProjectsCollector() {
            return this.myProjectsCollector;
        }
    }
}

