/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.editor.KotlinTypedHandlerHelper;
import org.jetbrains.kotlin.idea.editor.LtGtTypingUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "kotlinLTTyped", "", "isGlobalPreviousDollarInString", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "charTyped", "KotlinTypedHandlerTokenSets", "kotlin.base.code-insight.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinTypedHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTypedHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinTypedHandler\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,359:1\n125#2:360\n1#3:361\n*S KotlinDebug\n*F\n+ 1 KotlinTypedHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinTypedHandler\n*L\n285#1:360\n*E\n"})
public final class KotlinTypedHandler
extends TypedHandlerDelegate {
    private boolean kotlinLTTyped;
    private boolean isGlobalPreviousDollarInString;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        switch (c) {
            case ')': {
                KotlinTypedHandlerHelper.INSTANCE.dataClassValParameterInsert$kotlin_base_code_insight_minimal(project, editor, file, true);
                break;
            }
            case '<': {
                this.kotlinLTTyped = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.shouldAutoCloseAngleBracket(editor.getCaretModel().getOffset(), editor);
                KotlinTypedHandlerHelper.INSTANCE.autoPopupParameterInfo$kotlin_base_code_insight_minimal(project, editor);
                break;
            }
            case '>': {
                if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || !LtGtTypingUtils.handleKotlinGTInsert(editor)) break;
                return TypedHandlerDelegate.Result.STOP;
            }
            case '{': {
                PsiElement nonWhitespaceSibling;
                int offset = editor.getCaretModel().getOffset();
                if (offset == 0) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset - 1);
                Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
                HighlighterIterator iterator = highlighterIterator;
                while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                    iterator.retreat();
                }
                if (iterator.atEnd() || !KotlinTypedHandlerTokenSets.INSTANCE.getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER().contains(iterator.getTokenType())) {
                    AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor, null);
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                int tokenBeforeBraceOffset = iterator.getStart();
                Document document = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
                PsiElement leaf = file.findElementAt(offset);
                if (leaf == null) break;
                PsiElement parent = leaf.getParent();
                if (parent != null && KotlinTypedHandlerTokenSets.INSTANCE.getCONTROL_FLOW_EXPRESSIONS().contains(parent.getNode().getElementType()) && (nonWhitespaceSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)leaf)) != null && PsiTreeUtilKt.getStartOffset((PsiElement)nonWhitespaceSibling) == tokenBeforeBraceOffset) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{", (boolean)false, (boolean)true);
                    TypedHandler.indentBrace((Project)project, (Editor)editor, (char)'{');
                    return TypedHandlerDelegate.Result.STOP;
                }
                if (!Intrinsics.areEqual((Object)leaf.getText(), (Object)"}") || !(parent instanceof KtFunctionLiteral) || document2.getLineNumber(offset) != document2.getLineNumber(((KtFunctionLiteral)parent).getTextRange().getStartOffset())) break;
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{} ", (boolean)false, (boolean)false);
                editor.getCaretModel().moveToOffset(offset + 1);
                return TypedHandlerDelegate.Result.STOP;
            }
            case '.': {
                KotlinTypedHandlerHelper.INSTANCE.autoPopupMemberLookup$kotlin_base_code_insight_minimal(project, editor);
                break;
            }
            case ':': {
                KotlinTypedHandlerHelper.INSTANCE.autoPopupColon$kotlin_base_code_insight_minimal(project, editor);
                break;
            }
            case '[': {
                KotlinTypedHandlerHelper.INSTANCE.autoPopupParameterInfo$kotlin_base_code_insight_minimal(project, editor);
                break;
            }
            case '@': {
                KotlinTypedHandlerHelper.INSTANCE.autoPopupAt$kotlin_base_code_insight_minimal(project, editor);
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        block29: {
            block30: {
                boolean isSimpleLongTemplateEntry;
                LeafPsiElement $this$safeAs$iv;
                PsiElement previousElement;
                int offset;
                Integer previousDollarInStringOffset;
                block32: {
                    block31: {
                        LeafPsiElement leafPsiElement;
                        block28: {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                            if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE)) {
                                return TypedHandlerDelegate.Result.CONTINUE;
                            }
                            previousDollarInStringOffset = null;
                            if (this.isGlobalPreviousDollarInString) {
                                this.isGlobalPreviousDollarInString = false;
                                previousDollarInStringOffset = (Integer)editor.getUserData(KotlinTypedHandlerHelper.INSTANCE.getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_base_code_insight_minimal());
                            }
                            editor.putUserData(KotlinTypedHandlerHelper.INSTANCE.getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_base_code_insight_minimal(), null);
                            if (this.kotlinLTTyped) {
                                this.kotlinLTTyped = false;
                                LtGtTypingUtils.handleKotlinAutoCloseLT(editor);
                                return TypedHandlerDelegate.Result.STOP;
                            }
                            if (c != ',' && c != ')') break block28;
                            KotlinTypedHandlerHelper.INSTANCE.dataClassValParameterInsert$kotlin_base_code_insight_minimal(project, editor, file, false);
                            break block29;
                        }
                        if (c != '{' || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) break block30;
                        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                        offset = editor.getCaretModel().getOffset();
                        previousElement = file.findElementAt(offset - 1);
                        if (!(previousElement instanceof LeafPsiElement) || ((LeafPsiElement)previousElement).getElementType() != KtTokens.LONG_TEMPLATE_ENTRY_START) break block29;
                        PsiElement psiElement = file.findElementAt(offset);
                        if (psiElement == null) break block31;
                        PsiElement psiElement2 = psiElement;
                        boolean $i$f$safeAs = false;
                        LeafPsiElement leafPsiElement2 = $this$safeAs$iv;
                        if (!(leafPsiElement2 instanceof LeafPsiElement)) {
                            leafPsiElement2 = null;
                        }
                        if ((leafPsiElement = (LeafPsiElement)leafPsiElement2) == null) break block31;
                        LeafPsiElement it = $i$f$safeAs = leafPsiElement;
                        boolean bl = false;
                        Object object = $this$safeAs$iv = Intrinsics.areEqual((Object)it.getElementType(), (Object)KtTokens.IDENTIFIER) ? $i$f$safeAs : null;
                        if ($this$safeAs$iv != null) break block32;
                    }
                    boolean bl = false;
                    editor.getDocument().insertString(offset, (CharSequence)"}");
                    return TypedHandlerDelegate.Result.STOP;
                }
                LeafPsiElement identifier = $this$safeAs$iv;
                PsiElement lastInLongTemplateEntry = ((LeafPsiElement)previousElement).getParent().getLastChild();
                boolean bl = isSimpleLongTemplateEntry = lastInLongTemplateEntry instanceof LeafPsiElement && ((LeafPsiElement)lastInLongTemplateEntry).getElementType() == KtTokens.LONG_TEMPLATE_ENTRY_END && ((LeafPsiElement)lastInLongTemplateEntry).getParent().getTextLength() == identifier.getTextLength() + 3;
                if (!isSimpleLongTemplateEntry) {
                    boolean isAfterTypedDollar;
                    boolean bl2 = isAfterTypedDollar = previousDollarInStringOffset != null && previousDollarInStringOffset == offset - 1;
                    if (isAfterTypedDollar) {
                        editor.getDocument().insertString(offset, (CharSequence)"}");
                        return TypedHandlerDelegate.Result.STOP;
                    }
                }
                break block29;
            }
            if (c == ':') {
                if (KotlinTypedHandlerHelper.autoIndentCase$kotlin_base_code_insight_minimal$default(KotlinTypedHandlerHelper.INSTANCE, editor, project, file, KtClassOrObject.class, false, 16, null) || KotlinTypedHandlerHelper.autoIndentCase$kotlin_base_code_insight_minimal$default(KotlinTypedHandlerHelper.INSTANCE, editor, project, file, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '.') {
                if (KotlinTypedHandlerHelper.autoIndentCase$kotlin_base_code_insight_minimal$default(KotlinTypedHandlerHelper.INSTANCE, editor, project, file, KtQualifiedExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '|') {
                if (KotlinTypedHandlerHelper.autoIndentCase$kotlin_base_code_insight_minimal$default(KotlinTypedHandlerHelper.INSTANCE, editor, project, file, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '&') {
                if (KotlinTypedHandlerHelper.autoIndentCase$kotlin_base_code_insight_minimal$default(KotlinTypedHandlerHelper.INSTANCE, editor, project, file, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '$') {
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = file.findElementAt(offset);
                if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == KtTokens.REGULAR_STRING_PART) {
                    editor.putUserData(KotlinTypedHandlerHelper.INSTANCE.getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_base_code_insight_minimal(), (Object)offset);
                    this.isGlobalPreviousDollarInString = true;
                }
            } else if (c == '(' && KotlinTypedHandlerHelper.INSTANCE.autoIndentCase$kotlin_base_code_insight_minimal(editor, project, file, KtParameterList.class, false)) {
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandler$KotlinTypedHandlerTokenSets;", "", "<init>", "()V", "CONTROL_FLOW_EXPRESSIONS", "Lcom/intellij/psi/tree/TokenSet;", "getCONTROL_FLOW_EXPRESSIONS", "()Lcom/intellij/psi/tree/TokenSet;", "SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER", "getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER", "kotlin.base.code-insight.minimal"})
    private static final class KotlinTypedHandlerTokenSets {
        @NotNull
        public static final KotlinTypedHandlerTokenSets INSTANCE = new KotlinTypedHandlerTokenSets();
        @NotNull
        private static final TokenSet CONTROL_FLOW_EXPRESSIONS;
        @NotNull
        private static final TokenSet SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER;

        private KotlinTypedHandlerTokenSets() {
        }

        @NotNull
        public final TokenSet getCONTROL_FLOW_EXPRESSIONS() {
            return CONTROL_FLOW_EXPRESSIONS;
        }

        @NotNull
        public final TokenSet getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER() {
            return SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER;
        }

        static {
            IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.IF, KtNodeTypes.ELSE, KtNodeTypes.FOR, KtNodeTypes.WHILE, KtNodeTypes.TRY};
            TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
            CONTROL_FLOW_EXPRESSIONS = tokenSet;
            iElementTypeArray = new IElementType[]{KtTokens.RPAR, KtTokens.ELSE_KEYWORD, KtTokens.TRY_KEYWORD};
            TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
            SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER = tokenSet2;
        }
    }
}

