/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.geometric;

import com.amazon.redshift.geometric.RedshiftPoint;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class RedshiftPath
extends RedshiftObject
implements Serializable,
Cloneable {
    public boolean open;
    public RedshiftPoint[] points;

    public RedshiftPath(RedshiftPoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public RedshiftPath() {
        this.setType("path");
    }

    public RedshiftPath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = RedshiftTokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = RedshiftTokenizer.removePara(s);
        } else {
            throw new RedshiftException(GT.tr("Cannot tell if path is open or closed: {0}.", s), RedshiftState.DATA_TYPE_MISMATCH);
        }
        RedshiftTokenizer t = new RedshiftTokenizer(s, ',');
        int npoints = t.getSize();
        this.points = new RedshiftPoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new RedshiftPoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RedshiftPath) {
            RedshiftPath p = (RedshiftPath)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            if (p.open != this.open) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RedshiftPath newRSpath = (RedshiftPath)super.clone();
        if (newRSpath.points != null) {
            newRSpath.points = (RedshiftPoint[])newRSpath.points.clone();
            for (int i = 0; i < newRSpath.points.length; ++i) {
                newRSpath.points[i] = (RedshiftPoint)newRSpath.points[i].clone();
            }
        }
        return newRSpath;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder(this.open ? "[" : "(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

