/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Function;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.JavaSqlTypeGroup;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.Utility;
import us.fatehi.utility.graph.TreeNode;

public final class MetaDataUtility {
    private static final Logger LOGGER = Logger.getLogger(MetaDataUtility.class.getName());

    public static Collection<List<String>> allIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, false);
    }

    public static List<String> columnNames(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column indexColumn : index) {
            columnNames.add(indexColumn.getFullName());
        }
        return columnNames;
    }

    public static ForeignKeyCardinality findForeignKeyCardinality(TableReference tableRef) {
        if (tableRef == null) {
            return ForeignKeyCardinality.unknown;
        }
        boolean isForeignKeyUnique = MetaDataUtility.isForeignKeyUnique(tableRef);
        boolean isColumnReference = tableRef.getDependentTable() instanceof PartialDatabaseObject;
        ForeignKeyCardinality connectivity = isColumnReference ? ForeignKeyCardinality.unknown : (isForeignKeyUnique ? ForeignKeyCardinality.zero_one : ForeignKeyCardinality.zero_many);
        return connectivity;
    }

    public static List<String> foreignKeyColumnNames(TableReference tableRef) {
        if (tableRef == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnReference columnReference : tableRef) {
            columnNames.add(columnReference.getForeignKeyColumn().getFullName());
        }
        return columnNames;
    }

    public static String getColumnsListAsString(Index index, Identifiers identifiers) {
        Objects.requireNonNull(index, "No index provided");
        Objects.requireNonNull(identifiers, "No identifier quoting strategy provided");
        List<IndexColumn> columns = index.getColumns();
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    public static String getColumnsListAsString(Table table, Identifiers identifiers) {
        Objects.requireNonNull(table, "No table provided");
        Objects.requireNonNull(identifiers, "No identifier quoting strategy provided");
        List<Column> columns = table.getColumns();
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    public static String getColumnsListAsString(TableConstraint tableConstraint, Identifiers identifiers) {
        Objects.requireNonNull(tableConstraint, "No table constraint provided");
        Objects.requireNonNull(identifiers, "No identifier quoting strategy provided");
        List<TableConstraintColumn> columns = tableConstraint.getConstrainedColumns();
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    public static String getColumnsListAsString(TableReference fk, TableRelationshipType relationshipType, Identifiers identifiers) {
        Objects.requireNonNull(fk, "No foreign key provided");
        Objects.requireNonNull(identifiers, "No identifier quoting strategy provided");
        if (relationshipType == null || relationshipType == TableRelationshipType.none) {
            return "";
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (ColumnReference columnReference : fk.getColumnReferences()) {
            switch (relationshipType) {
                case parent: {
                    columns.add(columnReference.getPrimaryKeyColumn());
                    break;
                }
                case child: {
                    columns.add(columnReference.getForeignKeyColumn());
                    break;
                }
            }
        }
        return MetaDataUtility.joinColumns(columns, false, identifiers);
    }

    public static SimpleDatabaseObjectType getSimpleTypeName(DatabaseObject databaseObject) {
        if (databaseObject == null) {
            return SimpleDatabaseObjectType.unknown;
        }
        if (databaseObject instanceof Synonym) {
            return SimpleDatabaseObjectType.synonym;
        }
        if (databaseObject instanceof Sequence) {
            return SimpleDatabaseObjectType.sequence;
        }
        if (databaseObject instanceof Function) {
            return SimpleDatabaseObjectType.function;
        }
        if (databaseObject instanceof Procedure) {
            return SimpleDatabaseObjectType.procedure;
        }
        if (databaseObject instanceof View) {
            return SimpleDatabaseObjectType.view;
        }
        if (databaseObject instanceof Table) {
            return SimpleDatabaseObjectType.table;
        }
        return SimpleDatabaseObjectType.unknown;
    }

    public static String inclusionRuleString(InclusionRule inclusionRule) {
        String schemaInclusionPattern;
        String inclusionRuleString = ".*";
        if (inclusionRule instanceof InclusionRuleWithRegularExpression && !Utility.isBlank(schemaInclusionPattern = ((InclusionRuleWithRegularExpression)inclusionRule).getInclusionPattern().pattern())) {
            inclusionRuleString = schemaInclusionPattern;
        }
        return inclusionRuleString;
    }

    public static boolean isForeignKeyUnique(TableReference tableRef) {
        if (tableRef == null) {
            return false;
        }
        Table fkTable = tableRef.getForeignKeyTable();
        Collection<List<String>> uniqueIndexCoumnNames = MetaDataUtility.uniqueIndexCoumnNames(fkTable);
        List<String> foreignKeyColumnNames = MetaDataUtility.foreignKeyColumnNames(tableRef);
        return uniqueIndexCoumnNames.contains(foreignKeyColumnNames);
    }

    public static boolean isView(Table table) {
        return table instanceof View;
    }

    public static String joinColumns(List<? extends Column> columns, boolean omitLargeObjectColumns, Identifiers identifiers) {
        Objects.requireNonNull(columns, "No columns provided");
        Objects.requireNonNull(identifiers, "No identifiers provided");
        ArrayList<String> columnsList = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (!column.isColumnDataTypeKnown()) continue;
            JavaSqlTypeGroup javaSqlTypeGroup = column.getColumnDataType().getJavaSqlType().getJavaSqlTypeGroup();
            if (omitLargeObjectColumns && (javaSqlTypeGroup == JavaSqlTypeGroup.large_object || javaSqlTypeGroup == JavaSqlTypeGroup.object)) continue;
            columnsList.add(identifiers.quoteName(column.getName()));
        }
        return String.join((CharSequence)", ", columnsList);
    }

    public static void logCatalogSummary(Catalog catalog, Level logLevel) {
        if (catalog == null || logLevel == null) {
            return;
        }
        LOGGER.log(logLevel, () -> MetaDataUtility.summarizeCatalog(catalog));
    }

    public static void reduceCatalog(Catalog catalog, SchemaCrawlerOptions schemaCrawlerOptions) {
        Objects.requireNonNull(catalog, "No catalog provided");
        Objects.requireNonNull(schemaCrawlerOptions, "No SchemaCrawler options provided");
        catalog.undo(Schema.class, ReducerFactory.getSchemaReducer(schemaCrawlerOptions));
        catalog.reduce(Schema.class, ReducerFactory.getSchemaReducer(schemaCrawlerOptions));
        catalog.undo(Table.class, ReducerFactory.getTableReducer(schemaCrawlerOptions));
        catalog.reduce(Table.class, ReducerFactory.getTableReducer(schemaCrawlerOptions));
        catalog.undo(Routine.class, ReducerFactory.getRoutineReducer(schemaCrawlerOptions));
        catalog.reduce(Routine.class, ReducerFactory.getRoutineReducer(schemaCrawlerOptions));
        catalog.undo(Synonym.class, ReducerFactory.getSynonymReducer(schemaCrawlerOptions));
        catalog.reduce(Synonym.class, ReducerFactory.getSynonymReducer(schemaCrawlerOptions));
        catalog.undo(Sequence.class, ReducerFactory.getSequenceReducer(schemaCrawlerOptions));
        catalog.reduce(Sequence.class, ReducerFactory.getSequenceReducer(schemaCrawlerOptions));
    }

    public static String summarizeCatalog(Catalog catalog) {
        if (catalog == null) {
            return "";
        }
        TreeNode<String> countTree = new TreeNode<String>("catalog", catalog.getName());
        Collection<Schema> schemas = catalog.getSchemas();
        TreeNode<Integer> schemasNode = countTree.addChild(new TreeNode<Integer>("schemas", schemas.size()));
        for (Schema schema : schemas) {
            TreeNode<String> schemaNode = schemasNode.addChild(new TreeNode<String>("schema", schema.getFullName()));
            Collection<ColumnDataType> columnDataTypes = catalog.getColumnDataTypes(schema);
            schemaNode.addChild(new TreeNode<Integer>("data-types", columnDataTypes.size()));
            Collection<Table> tables = catalog.getTables(schema);
            TreeNode<Integer> tablesNode = schemaNode.addChild(new TreeNode<Integer>("tables", tables.size()));
            if (!tables.isEmpty()) {
                int columnCount = 0;
                int pkCount = 0;
                int fkCount = 0;
                int indexCount = 0;
                int triggerCount = 0;
                for (Table table : tables) {
                    columnCount += table.getColumns().size();
                    if (table.hasPrimaryKey()) {
                        ++pkCount;
                    }
                    fkCount += table.getImportedForeignKeys().size();
                    indexCount += table.getIndexes().size();
                    triggerCount += table.getTriggers().size();
                }
                tablesNode.addChild(new TreeNode<Integer>("columns", columnCount));
                tablesNode.addChild(new TreeNode<Integer>("primary-keys", pkCount));
                tablesNode.addChild(new TreeNode<Integer>("foreign-keys", fkCount));
                tablesNode.addChild(new TreeNode<Integer>("indexes", indexCount));
                tablesNode.addChild(new TreeNode<Integer>("triggers", triggerCount));
            }
            Collection<Routine> routines = catalog.getRoutines(schema);
            TreeNode<Integer> routinesNode = schemaNode.addChild(new TreeNode<Integer>("routines", routines.size()));
            if (!routines.isEmpty()) {
                int procedureCount = 0;
                int functionCount = 0;
                int parametersCount = 0;
                block6: for (Routine routine : routines) {
                    RoutineType routineType = (RoutineType)((Object)routine.getType());
                    switch (routineType) {
                        case procedure: {
                            ++procedureCount;
                            break;
                        }
                        case function: {
                            ++functionCount;
                            break;
                        }
                        default: {
                            continue block6;
                        }
                    }
                    parametersCount += routine.getParameters().size();
                }
                routinesNode.addChild(new TreeNode<Integer>("procedures", procedureCount));
                routinesNode.addChild(new TreeNode<Integer>("functions", functionCount));
                routinesNode.addChild(new TreeNode<Integer>("parameters", parametersCount));
            }
            Collection<Synonym> synonyms = catalog.getSynonyms(schema);
            schemaNode.addChild(new TreeNode<Integer>("synonyms", synonyms.size()));
            Collection<Sequence> sequences = catalog.getSequences(schema);
            schemaNode.addChild(new TreeNode<Integer>("sequences", sequences.size()));
        }
        CrawlInfo crawlInfo = catalog.getCrawlInfo();
        return String.format("Loaded catalog%n%s%n%s", crawlInfo, countTree);
    }

    public static Collection<List<String>> uniqueIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, true);
    }

    private static Collection<List<String>> indexCoumnNames(Table table, boolean includeUniqueOnly) {
        ArrayList<List<String>> allIndexCoumns = new ArrayList<List<String>>();
        if (table instanceof PartialDatabaseObject) {
            return allIndexCoumns;
        }
        for (Index index : table.getIndexes()) {
            if (includeUniqueOnly && !index.isUnique()) continue;
            List<String> indexColumns = MetaDataUtility.columnNames(index);
            allIndexCoumns.add(indexColumns);
        }
        return allIndexCoumns;
    }

    private MetaDataUtility() {
    }

    public static enum ForeignKeyCardinality {
        unknown(""),
        zero_one("(0..1)"),
        zero_many("(0..many)"),
        one_one("(1..1)");

        private final String description;

        private ForeignKeyCardinality(String description) {
            this.description = Objects.requireNonNull(description, "No description provided");
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum SimpleDatabaseObjectType {
        unknown,
        table,
        view,
        procedure,
        function,
        synonym,
        sequence;

    }
}

