/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes;

import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AlternateKeyBuilder;
import schemacrawler.crawl.WeakAssociationBuilder;
import schemacrawler.loader.attributes.model.AlternateKeyAttributes;
import schemacrawler.loader.attributes.model.CatalogAttributes;
import schemacrawler.loader.attributes.model.CatalogAttributesUtility;
import schemacrawler.loader.attributes.model.ColumnAttributes;
import schemacrawler.loader.attributes.model.TableAttributes;
import schemacrawler.loader.attributes.model.WeakAssociationAttributes;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskRunner;
import us.fatehi.utility.scheduler.TaskRunners;
import us.fatehi.utility.string.StringFormat;

public class AttributesCatalogLoader
extends BaseCatalogLoader {
    private static final Logger LOGGER = Logger.getLogger(AttributesCatalogLoader.class.getName());
    private static final String OPTION_ATTRIBUTES_FILE = "attributes-file";

    public AttributesCatalogLoader() {
        super(new PropertyName("attributesloader", "Loader for catalog attributes, such as remarks or tags"), 2);
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        PropertyName catalogLoaderName = this.getCatalogLoaderName();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand(catalogLoaderName);
        pluginCommand.addOption(OPTION_ATTRIBUTES_FILE, String.class, "Path to a YAML file with table and column attributes to add to the schema");
        return pluginCommand;
    }

    @Override
    public void loadCatalog() {
        if (!this.isLoaded()) {
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving catalog attributes");
        try (TaskRunner taskRunner = TaskRunners.getTaskRunner("loadAttributes", 1);){
            Catalog catalog = this.getCatalog();
            Config config = this.getAdditionalConfiguration();
            TaskDefinition.TaskRunnable taskRunnable = () -> {
                String catalogAttributesFile = config.getObject(OPTION_ATTRIBUTES_FILE, null);
                if (Utility.isBlank(catalogAttributesFile)) {
                    return;
                }
                InputResource inputResource = InputResourceUtility.createInputResource(catalogAttributesFile).orElseThrow(() -> new IORuntimeException(String.format("Cannot locate catalog attributes file <%s>", catalogAttributesFile)));
                CatalogAttributes catalogAttributes = CatalogAttributesUtility.readCatalogAttributes(inputResource);
                this.loadRemarks(catalog, catalogAttributes);
                this.loadAlternateKeys(catalog, catalogAttributes);
                this.loadWeakAssociations(catalog, catalogAttributes);
            };
            taskRunner.add(new TaskDefinition("retrieveCatalogAttributes", taskRunnable));
            taskRunner.submit();
            LOGGER.log(Level.INFO, taskRunner.report());
        }
        catch (IORuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Exception loading catalog attributes", e);
        }
    }

    private void loadAlternateKeys(Catalog catalog, CatalogAttributes catalogAttributes) {
        AlternateKeyBuilder alternateKeyBuilder = AlternateKeyBuilder.builder(catalog);
        for (AlternateKeyAttributes alternateKeyAttributes : catalogAttributes.getAlternateKeys()) {
            AlternateKeyBuilder.AlternateKeyDefinition alternateKeyDefinition = new AlternateKeyBuilder.AlternateKeyDefinition(alternateKeyAttributes.getSchema(), alternateKeyAttributes.getTableName(), alternateKeyAttributes.getName(), alternateKeyAttributes.getColumns());
            Optional<PrimaryKey> optionalAlternateKey = alternateKeyBuilder.addAlternateKey(alternateKeyDefinition);
            if (!optionalAlternateKey.isPresent()) continue;
            PrimaryKey alternateKey = optionalAlternateKey.get();
            alternateKey.setRemarks(alternateKeyAttributes.getRemarks());
            for (Map.Entry<String, String> attribute : alternateKeyAttributes.getAttributes().entrySet()) {
                alternateKey.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }
    }

    private void loadRemarks(Catalog catalog, CatalogAttributes catalogAttributes) {
        for (TableAttributes tableAttributes : catalogAttributes.getTables()) {
            Optional lookupTable = catalog.lookupTable(tableAttributes.getSchema(), tableAttributes.getName());
            if (!lookupTable.isPresent()) {
                LOGGER.log(Level.CONFIG, new StringFormat("Table %s not found", tableAttributes));
                continue;
            }
            Table table = (Table)lookupTable.get();
            if (tableAttributes.hasRemarks()) {
                table.setRemarks(tableAttributes.getRemarks());
            }
            for (ColumnAttributes columnAttributes : tableAttributes) {
                if (!columnAttributes.hasRemarks()) continue;
                Optional lookupColumn = table.lookupColumn(columnAttributes.getName());
                if (lookupColumn.isPresent()) {
                    Column column = (Column)lookupColumn.get();
                    column.setRemarks(columnAttributes.getRemarks());
                    continue;
                }
                LOGGER.log(Level.CONFIG, new StringFormat("Column %s not found", columnAttributes));
            }
        }
    }

    private void loadWeakAssociations(Catalog catalog, CatalogAttributes catalogAttributes) {
        for (WeakAssociationAttributes weakAssociationAttributes : catalogAttributes.getWeakAssociations()) {
            TableAttributes pkTableAttributes = weakAssociationAttributes.getReferencedTable();
            TableAttributes fkTableAttributes = weakAssociationAttributes.getDependentTable();
            WeakAssociationBuilder weakAssociationBuilder = WeakAssociationBuilder.builder(catalog);
            for (Map.Entry<String, String> entry : weakAssociationAttributes.getColumnReferences().entrySet()) {
                String fkColumnName = entry.getKey();
                String pkColumnName = entry.getValue();
                WeakAssociationBuilder.WeakAssociationColumn fkColumn = new WeakAssociationBuilder.WeakAssociationColumn(fkTableAttributes.getSchema(), fkTableAttributes.getName(), fkColumnName);
                WeakAssociationBuilder.WeakAssociationColumn pkColumn = new WeakAssociationBuilder.WeakAssociationColumn(pkTableAttributes.getSchema(), pkTableAttributes.getName(), pkColumnName);
                weakAssociationBuilder.addColumnReference(fkColumn, pkColumn);
            }
            Optional<TableReference> optionalTableReference = weakAssociationBuilder.findOrCreate(weakAssociationAttributes.getName());
            if (!optionalTableReference.isPresent()) continue;
            TableReference tableReference = optionalTableReference.get();
            tableReference.setRemarks(weakAssociationAttributes.getRemarks());
            for (Map.Entry<String, String> attribute : weakAssociationAttributes.getAttributes().entrySet()) {
                tableReference.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }
    }
}

