/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class OktaCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_APP_URL = "app_id";
    private static final String KEY_APP_NAME = "app_name";
    protected String m_app_id;
    protected String m_app_name;

    @Override
    public void addParameter(String key, String value) {
        super.addParameter(key, value);
        if (KEY_APP_URL.equalsIgnoreCase(key)) {
            this.m_app_id = value;
        }
        if (KEY_APP_NAME.equalsIgnoreCase(key)) {
            this.m_app_name = value;
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return (this.m_app_id != null ? this.m_app_id : "") + (this.m_app_name != null ? this.m_app_name : "");
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        this.checkRequiredParameters();
        if (StringUtils.isNullOrEmpty((String)this.m_app_id)) {
            throw new IOException("Missing required property: app_id");
        }
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
            String strOktaSessionToken = this.oktaAuthentication(httpClient);
            String string = this.handleSamlAssertion(httpClient, strOktaSessionToken);
            return string;
        }
        catch (GeneralSecurityException e) {
            throw new SdkClientException("Failed create SSLContext.", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)httpClient, null);
        }
    }

    private String oktaAuthentication(CloseableHttpClient httpClient) throws IOException {
        block6: {
            String string;
            CloseableHttpResponse responseAuthenticate = null;
            try {
                StatusLine statusLine;
                int requestStatus;
                ObjectMapper mapper = new ObjectMapper();
                String uri = "https://" + this.m_idpHost + "/api/v1/authn";
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logDebug("uri: {0}", uri);
                }
                this.validateURL(uri);
                HttpPost httpost = new HttpPost(uri);
                httpost.addHeader("Accept", "application/json");
                httpost.addHeader("Content-Type", "application/json");
                httpost.addHeader("Cache-Control", "no-cache");
                HashMap<String, String> creds = new HashMap<String, String>();
                creds.put("username", this.m_userName);
                creds.put("password", this.m_password);
                StringWriter writer = new StringWriter();
                mapper.writeValue((Writer)writer, creds);
                StringEntity entity = new StringEntity(writer.toString(), "UTF-8");
                entity.setContentType("application/json");
                httpost.setEntity((HttpEntity)entity);
                responseAuthenticate = httpClient.execute((HttpUriRequest)httpost);
                String content = EntityUtils.toString((HttpEntity)responseAuthenticate.getEntity());
                if (RedshiftLogger.isEnable()) {
                    String maskedContent = content.replaceAll(OktaCredentialsProvider.getRegexForJsonKey("sessionToken"), "$1***masked***\"");
                    maskedContent = maskedContent.replaceAll(OktaCredentialsProvider.getRegexForJsonKey("id"), "$1***masked***\"");
                    maskedContent = maskedContent.replaceAll(OktaCredentialsProvider.getRegexForJsonKey("passwordChanged"), "$1***masked***\"");
                    this.m_log.log(LogLevel.DEBUG, "oktaAuthentication https response:" + maskedContent, new Object[0]);
                }
                if ((requestStatus = (statusLine = responseAuthenticate.getStatusLine()).getStatusCode()) != 200) {
                    throw new IOException(statusLine.getReasonPhrase());
                }
                JsonNode json = mapper.readTree(content);
                if (!"SUCCESS".equals(json.get("status").asText())) break block6;
                string = json.get("sessionToken").asText();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(responseAuthenticate, null);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)responseAuthenticate, null);
            return string;
        }
        throw new IOException("No session token in the response.");
    }

    private String handleSamlAssertion(CloseableHttpClient httpClient, String oktaSessionToken) throws IOException {
        this.m_app_name = StringUtils.isNullOrEmpty((String)this.m_app_name) ? "amazon_aws" : URLEncoder.encode(this.m_app_name, "UTF-8");
        String oktaAWSAppUrl = "https://" + this.m_idpHost + "/home/" + this.m_app_name + "/" + this.m_app_id;
        String oktaAWSAppUrlWithToken = oktaAWSAppUrl + "?onetimetoken=" + oktaSessionToken;
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("oktaAWSAppUrl: {0}", oktaAWSAppUrl);
        }
        this.validateURL(oktaAWSAppUrlWithToken);
        HttpGet httpget = new HttpGet(oktaAWSAppUrlWithToken);
        CloseableHttpResponse responseSAML = httpClient.execute((HttpUriRequest)httpget);
        int requestStatus = responseSAML.getStatusLine().getStatusCode();
        if (requestStatus != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + responseSAML.getStatusLine().getStatusCode() + " : Reason : " + responseSAML.getStatusLine().getReasonPhrase());
        }
        String body = EntityUtils.toString((HttpEntity)responseSAML.getEntity());
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("body: {0}", this.sanitizeResponseBody(body));
        }
        for (String inputTags : this.getInputTagsfromHTML(body)) {
            String name = this.getValueByKey(inputTags, "name");
            String value = this.getValueByKey(inputTags, "value");
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("name: {0}", name);
            }
            if (!"SAMLResponse".equalsIgnoreCase(name)) continue;
            return value.replace("&#x2b;", "+").replace("&#x3d;", "=");
        }
        throw new IOException("Failed to retrieve SAMLAssertion.");
    }

    private String sanitizeResponseBody(String response) {
        Document document = Jsoup.parse((String)response);
        Element samlElement = document.selectFirst("input[name=SAMLResponse]");
        if (samlElement != null) {
            samlElement.val("***masked***");
            return document.toString();
        }
        return response;
    }
}

