/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.opentelemetry;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;
import net.snowflake.client.jdbc.internal.grpc.CallbackMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.DoubleCounterMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.DoubleHistogramMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.LongCounterMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.LongGaugeMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.LongHistogramMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.MetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.MetricSink;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributesBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.BatchCallback;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.DoubleCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.DoubleHistogram;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.LongCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.LongHistogram;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.Meter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableLongMeasurement;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableMeasurement;

final class OpenTelemetryMetricSink
implements MetricSink {
    private static final Logger logger = Logger.getLogger(OpenTelemetryMetricSink.class.getName());
    private final Object lock = new Object();
    private final Meter openTelemetryMeter;
    private final Map<String, Boolean> enableMetrics;
    private final boolean disableDefaultMetrics;
    private final Set<String> optionalLabels;
    private volatile List<MeasuresData> measures = new ArrayList<MeasuresData>();

    OpenTelemetryMetricSink(Meter meter, Map<String, Boolean> enableMetrics, boolean disableDefaultMetrics, List<String> optionalLabels) {
        this.openTelemetryMeter = Preconditions.checkNotNull(meter, "meter");
        this.enableMetrics = ImmutableMap.copyOf(enableMetrics);
        this.disableDefaultMetrics = disableDefaultMetrics;
        this.optionalLabels = ImmutableSet.copyOf(optionalLabels);
    }

    @Override
    public Map<String, Boolean> getEnabledMetrics() {
        return this.enableMetrics;
    }

    @Override
    public Set<String> getOptionalLabels() {
        return this.optionalLabels;
    }

    @Override
    public int getMeasuresSize() {
        return this.measures.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<MeasuresData> getMeasures() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(this.measures);
        }
    }

    @Override
    public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        DoubleCounter counter = (DoubleCounter)instrumentData.getMeasure();
        counter.add(value, attributes);
    }

    @Override
    public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        LongCounter counter = (LongCounter)instrumentData.getMeasure();
        counter.add(value, attributes);
    }

    @Override
    public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        DoubleHistogram histogram = (DoubleHistogram)instrumentData.getMeasure();
        histogram.record(value, attributes);
    }

    @Override
    public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        LongHistogram histogram = (LongHistogram)instrumentData.getMeasure();
        histogram.record(value, attributes);
    }

    @Override
    public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        ObservableLongMeasurement gauge = (ObservableLongMeasurement)instrumentData.getMeasure();
        gauge.record(value, attributes);
    }

    @Override
    public MetricSink.Registration registerBatchCallback(Runnable callback, CallbackMetricInstrument ... metricInstruments) {
        ArrayList<ObservableMeasurement> measurements = new ArrayList<ObservableMeasurement>(metricInstruments.length);
        for (CallbackMetricInstrument metricInstrument : metricInstruments) {
            MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
            if (instrumentData == null) continue;
            if (!(instrumentData.getMeasure() instanceof ObservableMeasurement)) {
                logger.log(Level.FINE, "Unsupported metric instrument type : {0} {1}", new Object[]{metricInstrument, instrumentData.getMeasure().getClass()});
                continue;
            }
            measurements.add((ObservableMeasurement)instrumentData.getMeasure());
        }
        if (measurements.isEmpty()) {
            return () -> {};
        }
        ObservableMeasurement first = (ObservableMeasurement)measurements.get(0);
        measurements.remove(0);
        BatchCallback closeable = this.openTelemetryMeter.batchCallback(callback, first, measurements.toArray(new ObservableMeasurement[0]));
        return closeable::close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMeasures(List<MetricInstrument> instruments) {
        Object object = this.lock;
        synchronized (object) {
            if (this.measures.size() >= instruments.size()) {
                return;
            }
            ArrayList<MeasuresData> newMeasures = new ArrayList<MeasuresData>(instruments.size());
            newMeasures.addAll(this.measures);
            for (int i = this.measures.size(); i < instruments.size(); ++i) {
                Object openTelemetryMeasure;
                MetricInstrument instrument = instruments.get(i);
                if (!this.shouldEnableMetric(instrument)) {
                    newMeasures.add(null);
                    continue;
                }
                BitSet bitSet = new BitSet(instrument.getOptionalLabelKeys().size());
                if (!this.optionalLabels.isEmpty()) {
                    List<String> labels = instrument.getOptionalLabelKeys();
                    for (int j = 0; j < labels.size(); ++j) {
                        if (!this.optionalLabels.contains(labels.get(j))) continue;
                        bitSet.set(j);
                    }
                }
                int index = instrument.getIndex();
                String name = instrument.getName();
                String unit = instrument.getUnit();
                String description = instrument.getDescription();
                if (instrument instanceof DoubleCounterMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.counterBuilder(name).setUnit(unit).setDescription(description).ofDoubles().build();
                } else if (instrument instanceof LongCounterMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.counterBuilder(name).setUnit(unit).setDescription(description).build();
                } else if (instrument instanceof DoubleHistogramMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.histogramBuilder(name).setUnit(unit).setDescription(description).build();
                } else if (instrument instanceof LongHistogramMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.histogramBuilder(name).setUnit(unit).setDescription(description).ofLongs().build();
                } else if (instrument instanceof LongGaugeMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.gaugeBuilder(name).setUnit(unit).setDescription(description).ofLongs().buildObserver();
                } else {
                    logger.log(Level.FINE, "Unsupported metric instrument type : {0}", instrument);
                    openTelemetryMeasure = null;
                }
                newMeasures.add(index, new MeasuresData(bitSet, openTelemetryMeasure));
            }
            this.measures = newMeasures;
        }
    }

    private boolean shouldEnableMetric(MetricInstrument instrument) {
        Boolean explicitlyEnabled = this.enableMetrics.get(instrument.getName());
        if (explicitlyEnabled != null) {
            return explicitlyEnabled;
        }
        return instrument.isEnableByDefault() && !this.disableDefaultMetrics;
    }

    private Attributes createAttributes(List<String> requiredLabelKeys, List<String> optionalLabelKeys, List<String> requiredLabelValues, List<String> optionalLabelValues, BitSet bitSet) {
        int i;
        AttributesBuilder builder = Attributes.builder();
        for (i = 0; i < requiredLabelKeys.size(); ++i) {
            builder.put(requiredLabelKeys.get(i), requiredLabelValues.get(i));
        }
        i = bitSet.nextSetBit(0);
        while (i >= 0 && i != Integer.MAX_VALUE) {
            builder.put(optionalLabelKeys.get(i), optionalLabelValues.get(i));
            i = bitSet.nextSetBit(i + 1);
        }
        return builder.build();
    }

    static final class MeasuresData {
        final BitSet optionalLabelsIndices;
        final Object measure;

        MeasuresData(BitSet optionalLabelsIndices, Object measure) {
            this.optionalLabelsIndices = optionalLabelsIndices;
            this.measure = measure;
        }

        public BitSet getOptionalLabelsBitSet() {
            return this.optionalLabelsIndices;
        }

        public Object getMeasure() {
            return this.measure;
        }
    }
}

