/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

final class GzipSupport {
    private GzipSupport() {
    }

    static GZIPInputStream newGzipInputStream(InputStream in) throws IOException {
        return new GZIPInputStream(new OptimisticAvailabilityInputStream(in));
    }

    private static final class OptimisticAvailabilityInputStream
    extends FilterInputStream {
        private int lastRead = 0;

        OptimisticAvailabilityInputStream(InputStream delegate) {
            super(delegate);
        }

        @Override
        public int available() throws IOException {
            return this.lastRead > -1 ? Integer.MAX_VALUE : 0;
        }

        @Override
        public int read() throws IOException {
            this.lastRead = super.read();
            return this.lastRead;
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.lastRead = super.read(b);
            return this.lastRead;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.lastRead = super.read(b, off, len);
            return this.lastRead;
        }
    }
}

