/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.assurance.evidences.IDDocumentDescription;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityVerificationMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityVerifier;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Deprecated
public class IDDocumentEvidence
extends IdentityEvidence {
    private final IdentityVerificationMethod method;
    private final DateWithTimeZoneOffset time;
    private final IdentityVerifier verifier;
    private final IDDocumentDescription idDocument;

    public IDDocumentEvidence(IdentityVerificationMethod method, IdentityVerifier verifier, DateWithTimeZoneOffset time, IDDocumentDescription idDocument) {
        super(IdentityEvidenceType.ID_DOCUMENT, null);
        this.method = method;
        this.time = time;
        this.verifier = verifier;
        this.idDocument = idDocument;
    }

    public IdentityVerificationMethod getVerificationMethod() {
        return this.method;
    }

    public DateWithTimeZoneOffset getVerificationTime() {
        return this.time;
    }

    public IdentityVerifier getVerifier() {
        return this.verifier;
    }

    public IDDocumentDescription getIdentityDocument() {
        return this.idDocument;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        if (this.getVerificationMethod() != null) {
            o.put("method", this.getVerificationMethod().getValue());
        }
        if (this.getVerificationTime() != null) {
            o.put("time", this.getVerificationTime().toISO8601String());
        }
        if (this.getVerifier() != null) {
            o.put("verifier", this.getVerifier().toJSONObject());
        }
        if (this.getIdentityDocument() != null) {
            o.put("document", this.getIdentityDocument().toJSONObject());
        }
        return o;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDDocumentEvidence)) {
            return false;
        }
        IDDocumentEvidence that = (IDDocumentEvidence)o;
        return Objects.equals(this.getVerificationMethod(), that.getVerificationMethod()) && Objects.equals(this.getVerificationTime(), that.getVerificationTime()) && Objects.equals(this.getVerifier(), that.getVerifier()) && Objects.equals(this.getIdentityDocument(), that.getIdentityDocument());
    }

    public int hashCode() {
        return Objects.hash(this.method, this.time, this.getVerifier(), this.idDocument);
    }

    public static IDDocumentEvidence parse(JSONObject jsonObject) throws ParseException {
        IDDocumentEvidence.ensureType(IdentityEvidenceType.ID_DOCUMENT, jsonObject);
        IdentityVerificationMethod method = null;
        if (jsonObject.get("method") != null) {
            method = new IdentityVerificationMethod(JSONObjectUtils.getNonBlankString(jsonObject, "method"));
        }
        DateWithTimeZoneOffset dtz = null;
        if (jsonObject.get("time") != null) {
            dtz = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getNonBlankString(jsonObject, "time"));
        }
        IdentityVerifier verifier = null;
        if (jsonObject.get("verifier") != null) {
            verifier = IdentityVerifier.parse(JSONObjectUtils.getJSONObject(jsonObject, "verifier"));
        }
        IDDocumentDescription idDocument = null;
        if (jsonObject.get("document") != null) {
            idDocument = IDDocumentDescription.parse(JSONObjectUtils.getJSONObject(jsonObject, "document"));
        }
        return new IDDocumentEvidence(method, verifier, dtz, idDocument);
    }
}

