/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.SerializeException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.Secret;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Immutable
public class ClientUpdateRequest
extends ProtectedResourceRequest {
    private final ClientID id;
    private final ClientMetadata metadata;
    private final Secret secret;

    public ClientUpdateRequest(URI endpoint, ClientID id, BearerAccessToken accessToken, ClientMetadata metadata, Secret secret) {
        super(endpoint, accessToken);
        this.id = Objects.requireNonNull(id);
        this.metadata = Objects.requireNonNull(metadata);
        this.secret = secret;
    }

    public ClientID getClientID() {
        return this.id;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    public Secret getClientSecret() {
        return this.secret;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.PUT, this.getEndpointURI());
        httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        httpRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONObject jsonObject = this.metadata.toJSONObject();
        jsonObject.put("client_id", this.id.getValue());
        if (this.secret != null) {
            jsonObject.put("client_secret", this.secret.getValue());
        }
        httpRequest.setBody(jsonObject.toString());
        return httpRequest;
    }

    public static ClientUpdateRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.PUT);
        BearerAccessToken accessToken = BearerAccessToken.parse(httpRequest.getAuthorization());
        JSONObject jsonObject = httpRequest.getBodyAsJSONObject();
        ClientID id = new ClientID(JSONObjectUtils.getNonBlankString(jsonObject, "client_id"));
        ClientMetadata metadata = ClientMetadata.parse(jsonObject);
        Secret clientSecret = null;
        if (jsonObject.get("client_secret") != null) {
            clientSecret = new Secret(JSONObjectUtils.getNonBlankString(jsonObject, "client_secret"));
        }
        return new ClientUpdateRequest(httpRequest.getURI(), id, accessToken, metadata, clientSecret);
    }
}

