/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.http.impl.client;

import net.snowflake.client.jdbc.internal.apache.http.HeaderElement;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.annotation.Contract;
import net.snowflake.client.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.client.jdbc.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import net.snowflake.client.jdbc.internal.apache.http.message.BasicHeaderElementIterator;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import net.snowflake.client.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1L;
    }
}

