/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.inclusionrule;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class RegularExpressionRule
implements InclusionRuleWithRegularExpression {
    private static final long serialVersionUID = 3443758881974362293L;
    private static final Logger LOGGER = Logger.getLogger(RegularExpressionRule.class.getName());
    private final Pattern patternExclude;
    private final Pattern patternInclude;

    public RegularExpressionRule(Pattern patternInclude, Pattern patternExclude) {
        this.patternInclude = patternInclude == null ? InclusionRuleWithRegularExpression.super.getInclusionPattern() : patternInclude;
        this.patternExclude = patternExclude == null ? InclusionRuleWithRegularExpression.super.getExclusionPattern() : patternExclude;
    }

    public RegularExpressionRule(String patternInclude, String patternExclude) {
        this(patternInclude == null ? null : Pattern.compile(patternInclude, 32), patternExclude == null ? null : Pattern.compile(patternExclude, 32));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InclusionRuleWithRegularExpression)) {
            return false;
        }
        InclusionRuleWithRegularExpression other = (InclusionRuleWithRegularExpression)obj;
        return this.getExclusionPattern().pattern().equals(other.getExclusionPattern().pattern()) && this.getInclusionPattern().pattern().equals(other.getInclusionPattern().pattern());
    }

    @Override
    public Pattern getExclusionPattern() {
        return this.patternExclude;
    }

    @Override
    public Pattern getInclusionPattern() {
        return this.patternInclude;
    }

    public int hashCode() {
        return Objects.hash(this.getExclusionPattern().pattern(), this.getInclusionPattern().pattern());
    }

    @Override
    public boolean test(String text) {
        StringFormat actionMessage;
        boolean include = false;
        if (!Utility.isBlank((CharSequence)text)) {
            if (!this.patternInclude.matcher(text).matches()) {
                actionMessage = new StringFormat("Excluding <%s> since it does not match /%s/", new Object[]{text, this.patternInclude.pattern()});
            } else if (this.patternExclude.matcher(text).matches()) {
                actionMessage = new StringFormat("Excluding <%s> since it matches /%s/", new Object[]{text, this.patternExclude.pattern()});
            } else {
                actionMessage = new StringFormat("Including <%s> since it matches /%s/", new Object[]{text, this.patternInclude.pattern()});
                include = true;
            }
        } else {
            actionMessage = new StringFormat("Excluding, since text is blank", new Object[0]);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, (String)actionMessage.get());
        }
        return include;
    }

    public String toString() {
        return String.format("%s@%h {+/%s/ -/%s/}", this.getClass().getSimpleName(), System.identityHashCode(this), this.patternInclude.pattern(), this.patternExclude.pattern());
    }
}

