/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.GrepOptions;
import us.fatehi.utility.string.StringFormat;

class TableGrepFilter
implements Predicate<Table> {
    private static final Logger LOGGER = Logger.getLogger(TableGrepFilter.class.getName());
    private final InclusionRule grepTableInclusionRule;
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;
    private final boolean invertMatch;

    public TableGrepFilter(GrepOptions options) {
        Objects.requireNonNull(options, "No grep options provided");
        this.invertMatch = options.isGrepInvertMatch();
        this.grepTableInclusionRule = options.getGrepTableInclusionRule().orElse(null);
        this.grepColumnInclusionRule = options.getGrepColumnInclusionRule().orElse(null);
        this.grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule().orElse(null);
    }

    @Override
    public boolean test(Table table) {
        boolean include;
        boolean checkIncludeForDefinitions;
        boolean checkIncludeForTables = this.grepTableInclusionRule != null;
        boolean checkIncludeForColumns = this.grepColumnInclusionRule != null;
        boolean bl = checkIncludeForDefinitions = this.grepDefinitionInclusionRule != null;
        if (!(checkIncludeForTables || checkIncludeForColumns || checkIncludeForDefinitions)) {
            if (this.invertMatch) {
                LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Ignoring the invert match setting for table <%s>, since no inclusion rules are set", new Object[]{table}));
            }
            return true;
        }
        boolean includeForTables = this.checkIncludeForTables(table);
        boolean includeForColumns = this.checkIncludeForColumns(table);
        boolean includeForDefinitions = this.checkIncludeForDefinitions(table);
        boolean bl2 = include = checkIncludeForTables && includeForTables || checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.invertMatch) {
            boolean bl3 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Excluding table <%s>", new Object[]{table}));
        }
        return include;
    }

    private boolean checkIncludeForColumns(Table table) {
        List<Column> columns = table.getColumns();
        if (columns.isEmpty()) {
            return true;
        }
        for (Column column : columns) {
            if (this.grepColumnInclusionRule == null || !this.grepColumnInclusionRule.test(column.getFullName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkIncludeForDefinitions(Table table) {
        if (this.grepDefinitionInclusionRule != null) {
            if (this.grepDefinitionInclusionRule.test(table.getRemarks()) || this.grepDefinitionInclusionRule.test(table.getDefinition())) {
                return true;
            }
            for (Trigger trigger : table.getTriggers()) {
                if (!this.grepDefinitionInclusionRule.test(trigger.getActionStatement())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkIncludeForTables(Table table) {
        return this.grepTableInclusionRule != null && this.grepTableInclusionRule.test(table.getFullName());
    }
}

