/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace;

import java.util.List;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.CompletableResultCode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.IdGenerator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.RandomIdGenerator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SpanLimits;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SpanProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.samplers.Sampler;

final class TracerSharedState {
    private final Object lock = new Object();
    private final Clock clock;
    private final IdGenerator idGenerator;
    private final boolean idGeneratorSafeToSkipIdValidation;
    private final Resource resource;
    private final Supplier<SpanLimits> spanLimitsSupplier;
    private final Sampler sampler;
    private final SpanProcessor activeSpanProcessor;
    @Nullable
    private volatile CompletableResultCode shutdownResult = null;

    TracerSharedState(Clock clock, IdGenerator idGenerator, Resource resource, Supplier<SpanLimits> spanLimitsSupplier, Sampler sampler, List<SpanProcessor> spanProcessors) {
        this.clock = clock;
        this.idGenerator = idGenerator;
        this.idGeneratorSafeToSkipIdValidation = idGenerator instanceof RandomIdGenerator;
        this.resource = resource;
        this.spanLimitsSupplier = spanLimitsSupplier;
        this.sampler = sampler;
        this.activeSpanProcessor = SpanProcessor.composite(spanProcessors);
    }

    Clock getClock() {
        return this.clock;
    }

    IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    boolean isIdGeneratorSafeToSkipIdValidation() {
        return this.idGeneratorSafeToSkipIdValidation;
    }

    Resource getResource() {
        return this.resource;
    }

    SpanLimits getSpanLimits() {
        return this.spanLimitsSupplier.get();
    }

    Sampler getSampler() {
        return this.sampler;
    }

    SpanProcessor getActiveSpanProcessor() {
        return this.activeSpanProcessor;
    }

    boolean hasBeenShutdown() {
        return this.shutdownResult != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableResultCode shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownResult != null) {
                return this.shutdownResult;
            }
            this.shutdownResult = this.activeSpanProcessor.shutdown();
            return this.shutdownResult;
        }
    }
}

