/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Tracer;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TracerBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TracerProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.CompletableResultCode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ComponentRegistry;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ScopeConfigurator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.IdGenerator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SdkTracer;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SdkTracerBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SpanLimits;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SpanProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.TracerSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.internal.TracerConfig;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.samplers.Sampler;

public final class SdkTracerProvider
implements TracerProvider,
Closeable {
    private static final Logger logger = Logger.getLogger(SdkTracerProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "";
    private final TracerSharedState sharedState;
    private final ComponentRegistry<SdkTracer> tracerSdkComponentRegistry;
    private final ScopeConfigurator<TracerConfig> tracerConfigurator;

    public static SdkTracerProviderBuilder builder() {
        return new SdkTracerProviderBuilder();
    }

    SdkTracerProvider(Clock clock, IdGenerator idsGenerator, Resource resource, Supplier<SpanLimits> spanLimitsSupplier, Sampler sampler, List<SpanProcessor> spanProcessors, ScopeConfigurator<TracerConfig> tracerConfigurator) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource, spanLimitsSupplier, sampler, spanProcessors);
        this.tracerSdkComponentRegistry = new ComponentRegistry<SdkTracer>(instrumentationScopeInfo -> new SdkTracer(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo, this.getTracerConfig((InstrumentationScopeInfo)instrumentationScopeInfo)));
        this.tracerConfigurator = tracerConfigurator;
    }

    private TracerConfig getTracerConfig(InstrumentationScopeInfo instrumentationScopeInfo) {
        TracerConfig tracerConfig = (TracerConfig)this.tracerConfigurator.apply((TracerConfig)((Object)instrumentationScopeInfo));
        return tracerConfig == null ? TracerConfig.defaultConfig() : tracerConfig;
    }

    @Override
    public Tracer get(String instrumentationScopeName) {
        return this.tracerBuilder(instrumentationScopeName).build();
    }

    @Override
    public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.tracerBuilder(instrumentationScopeName).setInstrumentationVersion(instrumentationScopeVersion).build();
    }

    @Override
    public TracerBuilder tracerBuilder(@Nullable String instrumentationScopeName) {
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            logger.fine("Tracer requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_TRACER_NAME;
        }
        return new SdkTracerBuilder(this.tracerSdkComponentRegistry, instrumentationScopeName);
    }

    public SpanLimits getSpanLimits() {
        return this.sharedState.getSpanLimits();
    }

    public Sampler getSampler() {
        return this.sharedState.getSampler();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkTracerProvider{clock=" + this.sharedState.getClock() + ", idGenerator=" + this.sharedState.getIdGenerator() + ", resource=" + this.sharedState.getResource() + ", spanLimitsSupplier=" + this.sharedState.getSpanLimits() + ", sampler=" + this.sharedState.getSampler() + ", spanProcessor=" + this.sharedState.getActiveSpanProcessor() + '}';
    }
}

