/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc;

import java.util.List;
import net.snowflake.client.jdbc.internal.grpc.Configurator;
import net.snowflake.client.jdbc.internal.grpc.ConfiguratorRegistry;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.InternalConfigurator;
import net.snowflake.client.jdbc.internal.grpc.ManagedChannelBuilder;
import net.snowflake.client.jdbc.internal.grpc.ServerBuilder;

@Internal
public final class InternalConfiguratorRegistry {
    private InternalConfiguratorRegistry() {
    }

    public static void setConfigurators(List<InternalConfigurator> configurators) {
        ConfiguratorRegistry.getDefaultRegistry().setConfigurators(configurators);
    }

    public static List<?> getConfigurators() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfigurators();
    }

    public static void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureChannelBuilder(channelBuilder);
        }
    }

    public static void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureServerBuilder(serverBuilder);
        }
    }

    public static boolean wasSetConfiguratorsCalled() {
        return ConfiguratorRegistry.getDefaultRegistry().wasSetConfiguratorsCalled();
    }
}

