/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.auth;

import java.net.URI;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceClient;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.auth.RegionAwareSigner;
import net.snowflake.client.jdbc.internal.amazonaws.auth.ServiceAwareSigner;
import net.snowflake.client.jdbc.internal.amazonaws.auth.Signer;
import net.snowflake.client.jdbc.internal.amazonaws.handlers.HandlerContextKey;
import net.snowflake.client.jdbc.internal.amazonaws.internal.auth.SignerProvider;
import net.snowflake.client.jdbc.internal.amazonaws.internal.auth.SignerProviderContext;
import net.snowflake.client.jdbc.internal.amazonaws.regions.EndpointToRegion;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.ServiceUtils;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class S3SignerProvider
extends SignerProvider {
    private static Log log = LogFactory.getLog(S3SignerProvider.class);
    private final AmazonWebServiceClient awsClient;
    private Signer signer;

    public S3SignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.signer = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext signerProviderContext) {
        URI uri = signerProviderContext.getUri();
        if (uri == null || ServiceUtils.isS3AccelerateEndpoint(uri.getHost()) || this.isSignerRegionOverrideSet()) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner && !this.isAccessPointUri(uri)) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(EndpointToRegion.guessRegionNameForEndpoint(uri.getHost(), "s3"));
            }
            catch (RuntimeException e) {
                log.warn("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region", e);
            }
        }
        Request<?> request = signerProviderContext.getRequest();
        if (!this.isSignerOverridden() && request != null && request.getHandlerContext(HandlerContextKey.SIGNING_NAME) != null) {
            String signingName = request.getHandlerContext(HandlerContextKey.SIGNING_NAME);
            if (this.signer instanceof ServiceAwareSigner) {
                ((ServiceAwareSigner)this.signer).setServiceName(signingName);
            }
        }
        return this.signer;
    }

    private boolean isAccessPointUri(URI uri) {
        String str = uri.toASCIIString();
        return str.contains(".s3-accesspoint.") || str.contains(".s3-outposts.") || str.contains(".s3-object-lambda.");
    }

    private boolean isSignerRegionOverrideSet() {
        return this.awsClient != null && this.awsClient.getSignerRegionOverride() != null;
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

