/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.oauth;

import java.net.URI;
import java.net.URISyntaxException;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.Curve;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.ECKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop.DefaultDPoPProofFactory;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.Nonce;

@SnowflakeJdbcInternalApi
public class DPoPUtil {
    private final ECKey jwk;

    DPoPUtil() throws SFException {
        try {
            this.jwk = new ECKeyGenerator(Curve.P_256).generate();
        }
        catch (JOSEException e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Error during DPoP JWK initialization: " + e.getMessage());
        }
    }

    public DPoPUtil(String jsonKey) throws SFException {
        try {
            this.jwk = ECKey.parse(jsonKey);
        }
        catch (Exception e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Error during DPoP JWK initialization: " + e.getMessage());
        }
    }

    String getPublicKey() {
        return this.jwk.toJSONString();
    }

    JWKThumbprintConfirmation getThumbprint() throws SFException {
        try {
            return JWKThumbprintConfirmation.of(this.jwk);
        }
        catch (JOSEException e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Error during JWK thumbprint generation: " + e.getMessage());
        }
    }

    public void addDPoPProofHeaderToRequest(HttpRequestBase httpRequest, String nonce) throws SFException {
        SignedJWT signedJWT = this.generateDPoPProof(httpRequest, nonce);
        httpRequest.setHeader("DPoP", signedJWT.serialize());
    }

    private SignedJWT generateDPoPProof(HttpRequestBase httpRequest, String nonce) throws SFException {
        try {
            DefaultDPoPProofFactory proofFactory = new DefaultDPoPProofFactory(this.jwk, JWSAlgorithm.ES256);
            if (nonce != null) {
                return proofFactory.createDPoPJWT(httpRequest.getMethod(), httpRequest.getURI(), new Nonce(nonce));
            }
            return proofFactory.createDPoPJWT(httpRequest.getMethod(), this.getUriWithoutQuery(httpRequest.getURI()));
        }
        catch (Exception e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, " Error during DPoP proof generation: " + e.getMessage());
        }
    }

    private URI getUriWithoutQuery(URI uri) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null);
    }
}

