/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverterUtil;
import net.snowflake.client.core.arrow.tostringhelpers.ArrowObjectStringRepresentationBuilder;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;

@SnowflakeJdbcInternalApi
public class StructConverter
extends AbstractArrowVectorConverter {
    private final StructVector structVector;

    public StructConverter(StructVector vector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.OBJECT.name(), vector, columnIndex, context);
        this.structVector = vector;
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : this.structVector.getObject(index);
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        return this.isNull(index) ? null : this.toString(index).getBytes();
    }

    @Override
    public String toString(int index) throws SFException {
        ArrowObjectStringRepresentationBuilder builder = new ArrowObjectStringRepresentationBuilder();
        for (String childName : this.structVector.getChildFieldNames()) {
            FieldVector fieldVector = this.structVector.getChild(childName);
            SnowflakeType logicalType = ArrowVectorConverterUtil.getSnowflakeTypeFromFieldMetadata(fieldVector.getField());
            try {
                if (fieldVector.isNull(index)) {
                    builder.appendKeyValue(childName, null, logicalType);
                    continue;
                }
                ArrowVectorConverter converter = ArrowVectorConverterUtil.initConverter(fieldVector, this.context, this.columnIndex);
                builder.appendKeyValue(childName, converter.toString(index), logicalType);
            }
            catch (SnowflakeSQLException e) {
                return this.structVector.getObject(index).toString();
            }
        }
        return builder.toString();
    }
}

