/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Stream;
import net.snowflake.client.core.ArrowSqlInput;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.ChunkDownloader;
import net.snowflake.client.core.ColumnTypeHelper;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.DownloaderMetrics;
import net.snowflake.client.core.JsonSqlInput;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.SfSqlArray;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.core.arrow.ArrayConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.MapConverter;
import net.snowflake.client.core.arrow.StructConverter;
import net.snowflake.client.core.arrow.StructObjectWrapper;
import net.snowflake.client.core.arrow.VarCharConverter;
import net.snowflake.client.core.arrow.VectorTypeConverter;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.jdbc.ArrowResultChunk;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.RootAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.JsonStringHashMap;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.Converter;

public class SFArrowResultSet
extends SFBaseResultSet
implements DataConversionContext {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFArrowResultSet.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.getObjectMapper();
    private ArrowResultChunk.ArrowChunkIterator currentChunkIterator;
    private String queryId;
    private SFStatementType statementType;
    private boolean totalRowCountTruncated;
    private boolean sortResult;
    protected SFBaseStatement statement;
    private final boolean arrayBindSupported;
    private long nextChunkIndex = 0L;
    private final long chunkCount;
    private ChunkDownloader chunkDownloader;
    private final long firstChunkTime;
    private final Telemetry telemetryClient;
    private RootAllocator rootAllocator;
    private boolean treatNTZAsUTC;
    private boolean useSessionTimezone;
    private boolean formatDateWithTimezone;
    @SnowflakeJdbcInternalApi
    protected Converters converters;

    public SFArrowResultSet(SnowflakeResultSetSerializableV1 resultSetSerializable, SFBaseSession session, SFBaseStatement statement, boolean sortResult) throws SQLException {
        this(resultSetSerializable, session.getTelemetryClient(), sortResult);
        this.converters = new Converters(resultSetSerializable.getTimeZone(), session, resultSetSerializable.getResultVersion(), resultSetSerializable.isHonorClientTZForTimestampNTZ(), resultSetSerializable.getTreatNTZAsUTC(), resultSetSerializable.getUseSessionTimezone(), resultSetSerializable.getFormatDateWithTimeZone(), resultSetSerializable.getBinaryFormatter(), resultSetSerializable.getDateFormatter(), resultSetSerializable.getTimeFormatter(), resultSetSerializable.getTimestampNTZFormatter(), resultSetSerializable.getTimestampLTZFormatter(), resultSetSerializable.getTimestampTZFormatter());
        this.statement = statement;
        session.setDatabase(resultSetSerializable.getFinalDatabaseName());
        session.setSchema(resultSetSerializable.getFinalSchemaName());
        session.setRole(resultSetSerializable.getFinalRoleName());
        session.setWarehouse(resultSetSerializable.getFinalWarehouseName());
        this.treatNTZAsUTC = resultSetSerializable.getTreatNTZAsUTC();
        this.formatDateWithTimezone = resultSetSerializable.getFormatDateWithTimeZone();
        this.useSessionTimezone = resultSetSerializable.getUseSessionTimezone();
        SessionUtil.updateSfDriverParamValues(this.parameters, statement.getSFBaseSession());
        if (resultSetSerializable.getSendResultTime() != 0L) {
            long timeConsumeFirstResult = this.firstChunkTime - resultSetSerializable.getSendResultTime();
            this.logMetric(TelemetryField.TIME_CONSUME_FIRST_RESULT, timeConsumeFirstResult);
        }
        StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, 0));
    }

    public SFArrowResultSet(SnowflakeResultSetSerializableV1 resultSetSerializable, Telemetry telemetryClient, boolean sortResult) throws SQLException {
        this.resultSetSerializable = resultSetSerializable;
        this.rootAllocator = resultSetSerializable.getRootAllocator();
        this.sortResult = sortResult;
        this.queryId = resultSetSerializable.getQueryId();
        this.statementType = resultSetSerializable.getStatementType();
        this.totalRowCountTruncated = resultSetSerializable.isTotalRowCountTruncated();
        this.parameters = resultSetSerializable.getParameters();
        this.chunkCount = resultSetSerializable.getChunkFileCount();
        this.chunkDownloader = resultSetSerializable.getChunkDownloader();
        this.honorClientTZForTimestampNTZ = resultSetSerializable.isHonorClientTZForTimestampNTZ();
        this.resultVersion = resultSetSerializable.getResultVersion();
        this.numberOfBinds = resultSetSerializable.getNumberOfBinds();
        this.arrayBindSupported = resultSetSerializable.isArrayBindSupported();
        this.metaDataOfBinds = resultSetSerializable.getMetaDataOfBinds();
        this.telemetryClient = telemetryClient;
        this.firstChunkTime = System.currentTimeMillis();
        this.timestampNTZFormatter = resultSetSerializable.getTimestampNTZFormatter();
        this.timestampLTZFormatter = resultSetSerializable.getTimestampLTZFormatter();
        this.timestampTZFormatter = resultSetSerializable.getTimestampTZFormatter();
        this.dateFormatter = resultSetSerializable.getDateFormatter();
        this.timeFormatter = resultSetSerializable.getTimeFormatter();
        this.sessionTimeZone = resultSetSerializable.getTimeZone();
        this.binaryFormatter = resultSetSerializable.getBinaryFormatter();
        this.resultSetMetaData = resultSetSerializable.getSFResultSetMetaData();
        this.treatNTZAsUTC = resultSetSerializable.getTreatNTZAsUTC();
        this.formatDateWithTimezone = resultSetSerializable.getFormatDateWithTimeZone();
        this.useSessionTimezone = resultSetSerializable.getUseSessionTimezone();
        String rowsetBase64 = resultSetSerializable.getFirstChunkStringData();
        if (rowsetBase64 == null || rowsetBase64.isEmpty()) {
            this.currentChunkIterator = ArrowResultChunk.getEmptyChunkIterator();
        } else if (sortResult) {
            if (resultSetSerializable.getChunkFileCount() > 0) {
                throw new SnowflakeSQLLoggedException(this.queryId, this.session, (int)ErrorCode.CLIENT_SIDE_SORTING_NOT_SUPPORTED.getMessageCode(), "0A000");
            }
            this.currentChunkIterator = this.getSortedFirstResultChunk(resultSetSerializable.getFirstChunkByteData()).getIterator(this);
        } else {
            this.currentChunkIterator = this.buildFirstChunk(resultSetSerializable.getFirstChunkByteData()).getIterator(this);
        }
    }

    private boolean fetchNextRow() throws SnowflakeSQLException {
        if (this.sortResult) {
            return this.fetchNextRowSorted();
        }
        return this.fetchNextRowUnsorted();
    }

    private boolean fetchNextRowUnsorted() throws SnowflakeSQLException {
        boolean hasNext = this.currentChunkIterator.next();
        if (hasNext) {
            return true;
        }
        if (this.nextChunkIndex < this.chunkCount) {
            try {
                StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, this.nextChunkIndex));
                ArrowResultChunk nextChunk = (ArrowResultChunk)this.chunkDownloader.getNextChunkToConsume();
                if (nextChunk == null) {
                    throw new SnowflakeSQLLoggedException(this.queryId, this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Expect chunk but got null for chunk index " + this.nextChunkIndex);
                }
                this.currentChunkIterator.getChunk().freeData();
                this.currentChunkIterator = nextChunk.getIterator(this);
                if (this.currentChunkIterator.next()) {
                    logger.debug("Moving to chunk index: {}, row count: {}", this.nextChunkIndex, nextChunk.getRowCount());
                    ++this.nextChunkIndex;
                    return true;
                }
                return false;
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLLoggedException(this.queryId, this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
            }
        }
        try {
            this.currentChunkIterator.getChunk().freeData();
            if (this.chunkCount > 0L) {
                logger.debug("End of chunks", false);
                DownloaderMetrics metrics = this.chunkDownloader.terminate();
                this.logChunkDownloaderMetrics(metrics);
            }
        }
        catch (InterruptedException e) {
            throw new SnowflakeSQLLoggedException(this.queryId, this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
        }
        return false;
    }

    private ArrowResultChunk buildFirstChunk(byte[] firstChunk) throws SQLException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(firstChunk);
        ArrowResultChunk resultChunk = new ArrowResultChunk("", 0, 0, 0, this.rootAllocator, this.session);
        try {
            resultChunk.readArrowStream(inputStream);
        }
        catch (IOException e) {
            throw new SnowflakeSQLLoggedException(this.queryId, this.session, ErrorCode.INTERNAL_ERROR, "Failed to load data in first chunk into arrow vector ex: " + e.getMessage());
        }
        return resultChunk;
    }

    private ArrowResultChunk getSortedFirstResultChunk(byte[] firstChunk) throws SQLException {
        ArrowResultChunk resultChunk = this.buildFirstChunk(firstChunk);
        resultChunk.enableSortFirstResultChunk();
        return resultChunk;
    }

    private boolean fetchNextRowSorted() throws SnowflakeSQLException {
        boolean hasNext = this.currentChunkIterator.next();
        if (hasNext) {
            return true;
        }
        this.currentChunkIterator.getChunk().freeData();
        return false;
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Converters getConverters() {
        return this.converters;
    }

    @Override
    @SnowflakeJdbcInternalApi
    public SQLInput createSqlInputForColumn(Object input, Class<?> parentObjectClass, int columnIndex, SFBaseSession session, List<FieldMetadata> fields) {
        if (parentObjectClass.equals(JsonSqlInput.class)) {
            return this.createJsonSqlInputForColumn(input, session, fields);
        }
        return new ArrowSqlInput((Map)input, session, this.converters, fields);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Date convertToDate(Object object, TimeZone tz) throws SFException {
        if (object instanceof String) {
            return this.convertStringToDate((String)object, tz);
        }
        return this.converters.getStructuredTypeDateTimeConverter().getDate((Integer)object, tz);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Time convertToTime(Object object, int scale) throws SFException {
        if (object instanceof String) {
            return this.convertStringToTime((String)object, scale);
        }
        return this.converters.getStructuredTypeDateTimeConverter().getTime((Long)object, scale);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Timestamp convertToTimestamp(Object object, int columnType, int columnSubType, TimeZone tz, int scale) throws SFException {
        if (object instanceof String) {
            return this.convertStringToTimestamp((String)object, columnType, columnSubType, tz, scale);
        }
        return this.converters.getStructuredTypeDateTimeConverter().getTimestamp((JsonStringHashMap)object, columnType, columnSubType, tz, scale);
    }

    @Override
    public boolean next() throws SFException, SnowflakeSQLException {
        if (this.isClosed()) {
            return false;
        }
        if (this.fetchNextRow()) {
            ++this.row;
            if (this.isLast()) {
                long timeConsumeLastResult = System.currentTimeMillis() - this.firstChunkTime;
                this.logMetric(TelemetryField.TIME_CONSUME_LAST_RESULT, timeConsumeLastResult);
            }
            return true;
        }
        logger.debug("End of result", false);
        if (this.totalRowCountTruncated || Boolean.TRUE.toString().equalsIgnoreCase(SnowflakeUtil.systemGetProperty("snowflake.enable_incident_test2"))) {
            throw new SFException(this.queryId, ErrorCode.MAX_RESULT_LIMIT_EXCEEDED, new Object[0]);
        }
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toByte(index);
    }

    @Override
    public String getString(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toString(index);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toBoolean(index);
    }

    @Override
    public short getShort(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toShort(index);
    }

    @Override
    public int getInt(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toInt(index);
    }

    @Override
    public long getLong(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toLong(index);
    }

    @Override
    public float getFloat(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toFloat(index);
    }

    @Override
    public double getDouble(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toDouble(index);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toBytes(index);
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        converter.setSessionTimeZone(this.sessionTimeZone);
        converter.setUseSessionTimezone(this.useSessionTimezone);
        return converter.toDate(index, tz, this.resultSetSerializable.getFormatDateWithTimeZone());
    }

    @Override
    public Time getTime(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        converter.setSessionTimeZone(this.sessionTimeZone);
        converter.setUseSessionTimezone(this.useSessionTimezone);
        return converter.toTime(index);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        converter.setSessionTimeZone(this.sessionTimeZone);
        converter.setUseSessionTimezone(this.useSessionTimezone);
        this.wasNull = converter.isNull(index);
        return converter.toTimestamp(index, tz);
    }

    @Override
    public Object getObject(int columnIndex) throws SFException {
        return this.getObjectRepresentation(columnIndex, true);
    }

    @Override
    @SnowflakeJdbcInternalApi
    public Object getObjectWithoutString(int columnIndex) throws SFException {
        return this.getObjectRepresentation(columnIndex, false);
    }

    private StructObjectWrapper getObjectRepresentation(int columnIndex, boolean withString) throws SFException {
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        if (type == 50003) {
            return new StructObjectWrapper(this.getString(columnIndex), null);
        }
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        converter.setTreatNTZAsUTC(this.treatNTZAsUTC);
        converter.setUseSessionTimezone(this.useSessionTimezone);
        converter.setSessionTimeZone(this.sessionTimeZone);
        Object obj = converter.toObject(index);
        if (obj == null) {
            return null;
        }
        boolean isStructuredType = this.resultSetMetaData.isStructuredTypeColumn(columnIndex);
        if (isStructuredType) {
            if (converter instanceof VarCharConverter) {
                if (type == 2002) {
                    JsonSqlInput jsonSqlInput = this.createJsonSqlInput(columnIndex, obj);
                    return new StructObjectWrapper(jsonSqlInput.getText(), jsonSqlInput);
                }
                if (type == 2003) {
                    SfSqlArray sfArray = this.getJsonArray((String)obj, columnIndex);
                    return new StructObjectWrapper(sfArray.getText(), sfArray);
                }
                throw new SFException(this.queryId, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
            }
            if (converter instanceof StructConverter) {
                String jsonString = withString ? converter.toString(index) : null;
                return new StructObjectWrapper(jsonString, this.createArrowSqlInput(columnIndex, (Map)obj));
            }
            if (converter instanceof MapConverter) {
                String jsonString = withString ? converter.toString(index) : null;
                return new StructObjectWrapper(jsonString, obj);
            }
            if (converter instanceof ArrayConverter || converter instanceof VectorTypeConverter) {
                String jsonString = converter.toString(index);
                return new StructObjectWrapper(jsonString, obj);
            }
            throw new SFException(this.queryId, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
        }
        return new StructObjectWrapper(null, obj);
    }

    private SQLInput createArrowSqlInput(int columnIndex, Map<String, Object> input) throws SFException {
        if (input == null) {
            return null;
        }
        return new ArrowSqlInput(input, this.session, this.converters, this.resultSetMetaData.getColumnFields(columnIndex));
    }

    private boolean isVarcharConvertedStruct(int type, ArrowVectorConverter converter) {
        return (type == 2002 || type == 2003) && converter instanceof VarCharConverter;
    }

    private JsonSqlInput createJsonSqlInput(int columnIndex, Object obj) throws SFException {
        try {
            if (obj == null) {
                return null;
            }
            String text = (String)obj;
            JsonNode jsonNode = OBJECT_MAPPER.readTree(text);
            return new JsonSqlInput(text, jsonNode, this.session, this.converters, this.resultSetMetaData.getColumnFields(columnIndex), this.sessionTimeZone);
        }
        catch (JsonProcessingException e) {
            throw new SFException(this.queryId, (Throwable)e, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        Object obj = converter.toObject(index);
        if (obj == null) {
            return null;
        }
        if (converter instanceof VarCharConverter) {
            return this.getJsonArray((String)obj, columnIndex);
        }
        if (converter instanceof ArrayConverter || converter instanceof VectorTypeConverter) {
            String jsonString = converter.toString(index);
            return this.getArrowArray(jsonString, (List)obj, columnIndex);
        }
        throw new SFException(this.queryId, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
    }

    private SfSqlArray getArrowArray(String text, List<Object> elements, int columnIndex) throws SFException {
        try {
            List<FieldMetadata> fieldMetadataList = this.resultSetMetaData.getColumnFields(columnIndex);
            if (fieldMetadataList.size() != 1) {
                throw new SFException(this.queryId, ErrorCode.INVALID_STRUCT_DATA, "Wrong size of fields for array type " + fieldMetadataList.size());
            }
            FieldMetadata fieldMetadata = fieldMetadataList.get(0);
            int columnSubType = fieldMetadata.getType();
            int columnType = ColumnTypeHelper.getColumnType(columnSubType, this.session);
            int scale = fieldMetadata.getScale();
            switch (columnType) {
                case 4: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.integerConverter(columnType)).toArray(Integer[]::new), this.session);
                }
                case 5: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.smallIntConverter(columnType)).toArray(Short[]::new), this.session);
                }
                case -6: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.tinyIntConverter(columnType)).toArray(Byte[]::new), this.session);
                }
                case -5: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.bigIntConverter(columnType)).toArray(Long[]::new), this.session);
                }
                case 2: 
                case 3: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.bigDecimalConverter(columnType)).toArray(BigDecimal[]::new), this.session);
                }
                case -16: 
                case 1: 
                case 12: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.varcharConverter(columnType, columnSubType, scale)).toArray(String[]::new), this.session);
                }
                case -2: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.bytesConverter(columnType, scale)).toArray(x$0 -> new Byte[x$0][]), this.session);
                }
                case 6: 
                case 7: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.floatConverter(columnType)).toArray(Float[]::new), this.session);
                }
                case 8: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.doubleConverter(columnType)).toArray(Double[]::new), this.session);
                }
                case 91: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.dateFromIntConverter(this.sessionTimeZone)).toArray(Date[]::new), this.session);
                }
                case 92: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.timeFromIntConverter(scale)).toArray(Time[]::new), this.session);
                }
                case 93: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.timestampFromStructConverter(columnType, columnSubType, this.sessionTimeZone, scale)).toArray(Timestamp[]::new), this.session);
                }
                case 16: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, this.converters.booleanConverter(columnType)).toArray(Boolean[]::new), this.session);
                }
                case 2002: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, e -> e).toArray(Map[]::new), this.session);
                }
                case 2003: {
                    return new SfSqlArray(text, columnSubType, this.mapAndConvert(elements, e -> ((List)e).stream().toArray(Map[]::new)).toArray(x$0 -> new Map[x$0][]), this.session);
                }
            }
            throw new SFException(this.queryId, ErrorCode.FEATURE_UNSUPPORTED, "Can't construct array for data type: " + columnSubType);
        }
        catch (RuntimeException e2) {
            throw new SFException(this.queryId, (Throwable)e2, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
        }
    }

    private <T> Stream<T> mapAndConvert(List<Object> elements, Converter<T> converter) {
        return elements.stream().map(obj -> {
            try {
                return converter.convert(obj);
            }
            catch (SFException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        converter.setSessionTimeZone(this.sessionTimeZone);
        converter.setUseSessionTimezone(this.useSessionTimezone);
        return converter.toBigDecimal(index);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SFException {
        BigDecimal bigDec = this.getBigDecimal(columnIndex);
        return bigDec == null ? null : bigDec.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public boolean isLast() {
        return this.nextChunkIndex == this.chunkCount && this.currentChunkIterator.isLast();
    }

    @Override
    public boolean isAfterLast() {
        return this.nextChunkIndex == this.chunkCount && this.currentChunkIterator.isAfterLast();
    }

    @Override
    public void close() throws SnowflakeSQLException {
        super.close();
        this.currentChunkIterator.getChunk().freeData();
        try {
            if (this.chunkDownloader != null) {
                DownloaderMetrics metrics = this.chunkDownloader.terminate();
                this.logChunkDownloaderMetrics(metrics);
            } else {
                SFArrowResultSet.closeRootAllocator(this.rootAllocator);
            }
        }
        catch (InterruptedException ex) {
            throw new SnowflakeSQLLoggedException(this.queryId, this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
        }
    }

    public static void closeRootAllocator(RootAllocator rootAllocator) {
        long rest = rootAllocator.getAllocatedMemory();
        int count = 3;
        try {
            while (rest > 0L && count-- > 0) {
                Thread.sleep(10L);
                rest = rootAllocator.getAllocatedMemory();
            }
            if (rest == 0L) {
                rootAllocator.close();
            }
        }
        catch (InterruptedException ie) {
            logger.debug("Interrupted during closing root allocator", false);
        }
        catch (Exception e) {
            logger.debug("Exception happened when closing rootAllocator: ", e.getLocalizedMessage());
        }
    }

    @Override
    public SFStatementType getStatementType() {
        return this.statementType;
    }

    @Override
    public void setStatementType(SFStatementType statementType) {
        this.statementType = statementType;
    }

    @Override
    public boolean isArrayBindSupported() {
        return this.arrayBindSupported;
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    private void logMetric(TelemetryField field, long value) {
        TelemetryData data = TelemetryUtil.buildJobData(this.queryId, field, value);
        this.telemetryClient.addLogToBatch(data);
    }

    private void logChunkDownloaderMetrics(DownloaderMetrics metrics) {
        if (metrics != null) {
            this.logMetric(TelemetryField.TIME_WAITING_FOR_CHUNKS, metrics.getMillisWaiting());
            this.logMetric(TelemetryField.TIME_DOWNLOADING_CHUNKS, metrics.getMillisDownloading());
            this.logMetric(TelemetryField.TIME_PARSING_CHUNKS, metrics.getMillisParsing());
        }
    }

    @Override
    public SnowflakeDateTimeFormat getTimestampLTZFormatter() {
        return this.timestampLTZFormatter;
    }

    @Override
    public SnowflakeDateTimeFormat getTimestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    @Override
    public SnowflakeDateTimeFormat getTimestampTZFormatter() {
        return this.timestampTZFormatter;
    }

    @Override
    public SnowflakeDateTimeFormat getDateFormatter() {
        return this.dateFormatter;
    }

    @Override
    public SnowflakeDateTimeFormat getTimeFormatter() {
        return this.timeFormatter;
    }

    @Override
    public SFBinaryFormat getBinaryFormatter() {
        return this.binaryFormatter;
    }

    @Override
    public int getScale(int columnIndex) {
        return this.resultSetMetaData.getScale(columnIndex);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.sessionTimeZone;
    }

    @Override
    public boolean getHonorClientTZForTimestampNTZ() {
        return this.honorClientTZForTimestampNTZ;
    }

    @Override
    public long getResultVersion() {
        return this.resultVersion;
    }
}

