/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.nestedfield;

import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import java.util.ArrayDeque;
import java.util.Deque;
import org.opensearch.sql.legacy.rewriter.nestedfield.From;
import org.opensearch.sql.legacy.rewriter.nestedfield.Identifier;
import org.opensearch.sql.legacy.rewriter.nestedfield.Scope;
import org.opensearch.sql.legacy.rewriter.nestedfield.Select;
import org.opensearch.sql.legacy.rewriter.nestedfield.Where;

public class NestedFieldRewriter
extends MySqlASTVisitorAdapter {
    private final Deque<Scope> environment = new ArrayDeque<Scope>();

    @Override
    public boolean visit(MySqlSelectQueryBlock query) {
        this.environment.push(new Scope());
        if (query.getFrom() == null) {
            return false;
        }
        query.getFrom().setParent(query);
        new From(query.getFrom()).rewrite(this.curScope());
        if (this.curScope().isAnyNestedField() && this.isNotGroupBy(query)) {
            new Select(query.getSelectList()).rewrite(this.curScope());
        }
        query.putAttribute("NestedJoinType", (Object)this.curScope().getActualJoinType());
        return true;
    }

    @Override
    public boolean visit(SQLIdentifierExpr expr) {
        if (this.curScope().isAnyNestedField()) {
            new Identifier(expr).rewrite(this.curScope());
        }
        return true;
    }

    @Override
    public void endVisit(SQLBinaryOpExpr expr) {
        if (this.curScope().isAnyNestedField()) {
            new Where(expr).rewrite(this.curScope());
        }
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock query) {
        this.environment.pop();
    }

    private Scope curScope() {
        return this.environment.peek();
    }

    private boolean isNotGroupBy(MySqlSelectQueryBlock query) {
        return query.getGroupBy() == null;
    }
}

