/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.upload_chunk;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLUploadModelChunkInput
implements ToXContentObject,
Writeable {
    public static final String CONTENT_FIELD = "model_content";
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String CHUNK_NUMBER_FIELD = "chunk_number";
    private byte[] content;
    private String modelId;
    private Integer chunkNumber;

    public MLUploadModelChunkInput(String modelId, Integer chunkNumber, byte[] content) {
        this.content = content;
        this.modelId = modelId;
        this.chunkNumber = chunkNumber;
    }

    public MLUploadModelChunkInput(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.chunkNumber = in.readInt();
        boolean uploadModel = in.readBoolean();
        if (uploadModel) {
            this.content = in.readByteArray();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeInt(this.chunkNumber.intValue());
        if (this.content == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByteArray(this.content);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID_FIELD, this.modelId);
        builder.field(CHUNK_NUMBER_FIELD, this.chunkNumber);
        builder.field(CONTENT_FIELD, this.content);
        builder.endObject();
        return builder;
    }

    public static MLUploadModelChunkInput parse(XContentParser parser, byte[] content) throws IOException {
        Integer chunkNumber = null;
        String modelId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    modelId = parser.text();
                    continue block8;
                }
                case "chunk_number": {
                    chunkNumber = parser.intValue();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new MLUploadModelChunkInput(modelId, chunkNumber, content);
    }

    @Generated
    public static MLUploadModelChunkInputBuilder builder() {
        return new MLUploadModelChunkInputBuilder();
    }

    @Generated
    public MLUploadModelChunkInputBuilder toBuilder() {
        return new MLUploadModelChunkInputBuilder().modelId(this.modelId).chunkNumber(this.chunkNumber).content(this.content);
    }

    @Generated
    public byte[] getContent() {
        return this.content;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public Integer getChunkNumber() {
        return this.chunkNumber;
    }

    @Generated
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setChunkNumber(Integer chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLUploadModelChunkInput)) {
            return false;
        }
        MLUploadModelChunkInput other = (MLUploadModelChunkInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$chunkNumber = this.getChunkNumber();
        Integer other$chunkNumber = other.getChunkNumber();
        if (this$chunkNumber == null ? other$chunkNumber != null : !((Object)this$chunkNumber).equals(other$chunkNumber)) {
            return false;
        }
        if (!Arrays.equals(this.getContent(), other.getContent())) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        return !(this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLUploadModelChunkInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Integer $chunkNumber = this.getChunkNumber();
        result2 = result2 * 59 + ($chunkNumber == null ? 43 : ((Object)$chunkNumber).hashCode());
        result2 = result2 * 59 + Arrays.hashCode(this.getContent());
        String $modelId = this.getModelId();
        result2 = result2 * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "MLUploadModelChunkInput(content=" + Arrays.toString(this.getContent()) + ", modelId=" + this.getModelId() + ", chunkNumber=" + this.getChunkNumber() + ")";
    }

    @Generated
    public static class MLUploadModelChunkInputBuilder {
        @Generated
        private String modelId;
        @Generated
        private Integer chunkNumber;
        @Generated
        private byte[] content;

        @Generated
        MLUploadModelChunkInputBuilder() {
        }

        @Generated
        public MLUploadModelChunkInputBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLUploadModelChunkInputBuilder chunkNumber(Integer chunkNumber) {
            this.chunkNumber = chunkNumber;
            return this;
        }

        @Generated
        public MLUploadModelChunkInputBuilder content(byte[] content) {
            this.content = content;
            return this;
        }

        @Generated
        public MLUploadModelChunkInput build() {
            return new MLUploadModelChunkInput(this.modelId, this.chunkNumber, this.content);
        }

        @Generated
        public String toString() {
            return "MLUploadModelChunkInput.MLUploadModelChunkInputBuilder(modelId=" + this.modelId + ", chunkNumber=" + this.chunkNumber + ", content=" + Arrays.toString(this.content) + ")";
        }
    }
}

