/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLSearchMemoriesInput
implements ToXContentObject,
Writeable {
    private String memoryContainerId;
    private String query;

    public MLSearchMemoriesInput(String memoryContainerId, String query) {
        if (StringUtils.isBlank(query)) {
            throw new IllegalArgumentException("Query cannot be null or empty");
        }
        this.memoryContainerId = memoryContainerId;
        this.query = query.trim();
    }

    public MLSearchMemoriesInput(StreamInput in) throws IOException {
        this.memoryContainerId = in.readOptionalString();
        this.query = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.memoryContainerId);
        out.writeString(this.query);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.memoryContainerId != null) {
            builder.field("memory_container_id", this.memoryContainerId);
        }
        builder.field("query", this.query);
        builder.endObject();
        return builder;
    }

    public static MLSearchMemoriesInput parse(XContentParser parser) throws IOException {
        String memoryContainerId = null;
        String query = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "memory_container_id": {
                    memoryContainerId = parser.text();
                    continue block8;
                }
                case "query": {
                    query = parser.text();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return MLSearchMemoriesInput.builder().memoryContainerId(memoryContainerId).query(query).build();
    }

    @Generated
    public static MLSearchMemoriesInputBuilder builder() {
        return new MLSearchMemoriesInputBuilder();
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public void setMemoryContainerId(String memoryContainerId) {
        this.memoryContainerId = memoryContainerId;
    }

    @Generated
    public void setQuery(String query) {
        this.query = query;
    }

    @Generated
    public static class MLSearchMemoriesInputBuilder {
        @Generated
        private String memoryContainerId;
        @Generated
        private String query;

        @Generated
        MLSearchMemoriesInputBuilder() {
        }

        @Generated
        public MLSearchMemoriesInputBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLSearchMemoriesInputBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public MLSearchMemoriesInput build() {
            return new MLSearchMemoriesInput(this.memoryContainerId, this.query);
        }

        @Generated
        public String toString() {
            return "MLSearchMemoriesInput.MLSearchMemoriesInputBuilder(memoryContainerId=" + this.memoryContainerId + ", query=" + this.query + ")";
        }
    }
}

