/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ConvergenceFailureException;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.AzimuthalProjection;
import org.locationtech.proj4j.util.ProjectionMath;

public class StereographicAzimuthalProjection
extends AzimuthalProjection {
    private static final double TOL = 1.0E-8;
    private double akm1;

    public StereographicAzimuthalProjection() {
        this(Math.toRadians(90.0), Math.toRadians(0.0));
    }

    public StereographicAzimuthalProjection(double projectionLatitude, double projectionLongitude) {
        super(projectionLatitude, projectionLongitude);
        this.initialize();
    }

    public void setupUPS(int pole) {
        this.projectionLatitude = pole == 2 ? -1.5707963267948966 : 1.5707963267948966;
        this.projectionLongitude = 0.0;
        this.scaleFactor = 0.994;
        this.falseEasting = 2000000.0;
        this.falseNorthing = 2000000.0;
        this.trueScaleLatitude = 1.5707963267948966;
        this.initialize();
    }

    @Override
    public void initialize() {
        double d;
        super.initialize();
        double t2 = Math.abs(this.projectionLatitude);
        this.mode = Math.abs(d - 1.5707963267948966) < 1.0E-10 ? (this.projectionLatitude < 0.0 ? 2 : 1) : (t2 > 1.0E-10 ? 4 : 3);
        this.trueScaleLatitude = Math.abs(this.trueScaleLatitude);
        if (!this.spherical) {
            switch (this.mode) {
                case 1: 
                case 2: {
                    if (Math.abs(this.trueScaleLatitude - 1.5707963267948966) < 1.0E-10) {
                        this.akm1 = 2.0 * this.scaleFactor / Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e));
                        break;
                    }
                    t2 = Math.sin(this.trueScaleLatitude);
                    this.akm1 = Math.cos(this.trueScaleLatitude) / ProjectionMath.tsfn(this.trueScaleLatitude, t2, this.e);
                    this.akm1 /= Math.sqrt(1.0 - (t2 *= this.e) * t2);
                    break;
                }
                case 3: {
                    this.akm1 = 2.0 * this.scaleFactor;
                    break;
                }
                case 4: {
                    t2 = Math.sin(this.projectionLatitude);
                    double X = 2.0 * Math.atan(this.ssfn(this.projectionLatitude, t2, this.e)) - 1.5707963267948966;
                    this.akm1 = 2.0 * this.scaleFactor * Math.cos(this.projectionLatitude) / Math.sqrt(1.0 - (t2 *= this.e) * t2);
                    this.sinphi0 = Math.sin(X);
                    this.cosphi0 = Math.cos(X);
                }
            }
        } else {
            switch (this.mode) {
                case 4: {
                    this.sinphi0 = Math.sin(this.projectionLatitude);
                    this.cosphi0 = Math.cos(this.projectionLatitude);
                }
                case 3: {
                    this.akm1 = 2.0 * this.scaleFactor;
                    break;
                }
                case 1: 
                case 2: {
                    this.akm1 = Math.abs(this.trueScaleLatitude - 1.5707963267948966) >= 1.0E-10 ? Math.cos(this.trueScaleLatitude) / Math.tan(0.7853981633974483 - 0.5 * this.trueScaleLatitude) : 2.0 * this.scaleFactor;
                }
            }
        }
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        double coslam = Math.cos(lam);
        double sinlam = Math.sin(lam);
        double sinphi = Math.sin(phi);
        if (this.spherical) {
            double cosphi = Math.cos(phi);
            switch (this.mode) {
                case 3: {
                    xy.y = 1.0 + cosphi * coslam;
                    if (xy.y <= 1.0E-10) {
                        throw new ProjectionException();
                    }
                    xy.y = this.akm1 / xy.y;
                    xy.x = xy.y * cosphi * sinlam;
                    xy.y *= sinphi;
                    break;
                }
                case 4: {
                    xy.y = 1.0 + this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam;
                    if (xy.y <= 1.0E-10) {
                        throw new ProjectionException();
                    }
                    xy.y = this.akm1 / xy.y;
                    xy.x = xy.y * cosphi * sinlam;
                    xy.y *= this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam;
                    break;
                }
                case 1: {
                    coslam = -coslam;
                    phi = -phi;
                }
                case 2: {
                    if (Math.abs(phi - 1.5707963267948966) < 1.0E-8) {
                        throw new ProjectionException();
                    }
                    xy.y = this.akm1 * Math.tan(0.7853981633974483 + 0.5 * phi);
                    xy.x = sinlam * xy.y;
                    xy.y *= coslam;
                }
            }
        } else {
            double sinX = 0.0;
            double cosX = 0.0;
            if (this.mode == 4 || this.mode == 3) {
                double X = 2.0 * Math.atan(this.ssfn(phi, sinphi, this.e)) - 1.5707963267948966;
                sinX = Math.sin(X);
                cosX = Math.cos(X);
            }
            switch (this.mode) {
                case 4: {
                    double A2 = this.akm1 / (this.cosphi0 * (1.0 + this.sinphi0 * sinX + this.cosphi0 * cosX * coslam));
                    xy.y = A2 * (this.cosphi0 * sinX - this.sinphi0 * cosX * coslam);
                    xy.x = A2 * cosX;
                    break;
                }
                case 3: {
                    double A3 = this.akm1 / (1.0 + cosX * coslam);
                    xy.y = A3 * sinX;
                    xy.x = A3 * cosX;
                    break;
                }
                case 2: {
                    phi = -phi;
                    coslam = -coslam;
                    sinphi = -sinphi;
                }
                case 1: {
                    xy.x = this.akm1 * ProjectionMath.tsfn(phi, sinphi, this.e);
                    xy.y = -xy.x * coslam;
                }
            }
            xy.x *= sinlam;
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        if (this.spherical) {
            double rh = ProjectionMath.distance(x, y);
            double c = 2.0 * Math.atan(rh / this.akm1);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            lp.x = 0.0;
            switch (this.mode) {
                case 3: {
                    lp.y = Math.abs(rh) <= 1.0E-10 ? 0.0 : Math.asin(y * sinc / rh);
                    if (cosc == 0.0 && x == 0.0) break;
                    lp.x = Math.atan2(x * sinc, cosc * rh);
                    break;
                }
                case 4: {
                    lp.y = Math.abs(rh) <= 1.0E-10 ? this.projectionLatitude : Math.asin(cosc * this.sinphi0 + y * sinc * this.cosphi0 / rh);
                    c = cosc - this.sinphi0 * Math.sin(lp.y);
                    if (c == 0.0 && x == 0.0) break;
                    lp.x = Math.atan2(x * sinc * this.cosphi0, c * rh);
                    break;
                }
                case 1: {
                    y = -y;
                }
                case 2: {
                    lp.y = Math.abs(rh) <= 1.0E-10 ? this.projectionLatitude : Math.asin(this.mode == 2 ? -cosc : cosc);
                    lp.x = x == 0.0 && y == 0.0 ? 0.0 : Math.atan2(x, y);
                }
            }
        } else {
            double halfe;
            double halfpi;
            double phi_l;
            double sinphi;
            double tp;
            double rho = ProjectionMath.distance(x, y);
            switch (this.mode) {
                default: {
                    tp = 2.0 * Math.atan2(rho * this.cosphi0, this.akm1);
                    double cosphi = Math.cos(tp);
                    sinphi = Math.sin(tp);
                    phi_l = rho <= 0.0 ? Math.asin(cosphi * this.sinphi0) : Math.asin(cosphi * this.sinphi0 + y * sinphi * this.cosphi0 / rho);
                    tp = Math.tan(0.5 * (1.5707963267948966 + phi_l));
                    x *= sinphi;
                    y = rho * this.cosphi0 * cosphi - y * this.sinphi0 * sinphi;
                    halfpi = 1.5707963267948966;
                    halfe = 0.5 * this.e;
                    break;
                }
                case 1: {
                    y = -y;
                }
                case 2: {
                    tp = -rho / this.akm1;
                    phi_l = 1.5707963267948966 - 2.0 * Math.atan(tp);
                    halfpi = -1.5707963267948966;
                    halfe = -0.5 * this.e;
                }
            }
            int i = 8;
            while (i-- != 0) {
                sinphi = this.e * Math.sin(phi_l);
                lp.y = 2.0 * Math.atan(tp * Math.pow((1.0 + sinphi) / (1.0 - sinphi), halfe)) - halfpi;
                if (Math.abs(phi_l - lp.y) < 1.0E-10) {
                    if (this.mode == 2) {
                        lp.y = -lp.y;
                    }
                    lp.x = x == 0.0 && y == 0.0 ? 0.0 : Math.atan2(x, y);
                    return lp;
                }
                phi_l = lp.y;
            }
            throw new ConvergenceFailureException("Iteration didn't converge");
        }
        return lp;
    }

    @Override
    public boolean isConformal() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    private double ssfn(double phit, double sinphi, double eccen) {
        return Math.tan(0.5 * (1.5707963267948966 + phit)) * Math.pow((1.0 - (sinphi *= eccen)) / (1.0 + sinphi), 0.5 * eccen);
    }

    @Override
    public String toString() {
        return "Stereographic Azimuthal";
    }
}

