/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DerivationFunction;
import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.HKDFParameters;

class HKDFBytesGenerator
implements DerivationFunction {
    private HMac hMacHash;
    private int hashLen;
    private byte[] info;
    private byte[] currentT;
    private int generatedBytes;

    public HKDFBytesGenerator(Digest digest) {
        this.hMacHash = new HMac(digest);
        this.hashLen = digest.getDigestSize();
    }

    public HKDFBytesGenerator(HMac hMac) {
        this.hMacHash = hMac;
        this.hashLen = hMac.getUnderlyingDigest().getDigestSize();
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof HKDFParameters)) {
            throw new IllegalArgumentException("HKDF parameters required for HKDFBytesGenerator");
        }
        HKDFParameters hKDFParameters = (HKDFParameters)derivationParameters;
        this.hMacHash.init(hKDFParameters.getKey());
        this.info = hKDFParameters.getInfo();
        this.generatedBytes = 0;
        this.currentT = new byte[this.hashLen];
    }

    private void expandNext() throws DataLengthException {
        int n = this.generatedBytes / this.hashLen + 1;
        if (n >= 256) {
            throw new DataLengthException("HKDF cannot generate more than 255 blocks of HashLen size");
        }
        if (this.generatedBytes != 0) {
            this.hMacHash.update(this.currentT, 0, this.hashLen);
        }
        this.hMacHash.update(this.info, 0, this.info.length);
        this.hMacHash.update((byte)n);
        this.hMacHash.doFinal(this.currentT, 0);
    }

    public Digest getDigest() {
        return this.hMacHash.getUnderlyingDigest();
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (this.generatedBytes + n2 > 255 * this.hashLen) {
            throw new DataLengthException("HKDF may only be used for 255 * HashLen bytes of output");
        }
        if (this.generatedBytes % this.hashLen == 0) {
            this.expandNext();
        }
        int n3 = n2;
        int n4 = this.generatedBytes % this.hashLen;
        int n5 = this.hashLen - this.generatedBytes % this.hashLen;
        int n6 = Math.min(n5, n3);
        System.arraycopy(this.currentT, n4, byArray, n, n6);
        this.generatedBytes += n6;
        n3 -= n6;
        n += n6;
        while (n3 > 0) {
            this.expandNext();
            n6 = Math.min(this.hashLen, n3);
            System.arraycopy(this.currentT, 0, byArray, n, n6);
            this.generatedBytes += n6;
            n3 -= n6;
            n += n6;
        }
        return n2;
    }
}

