function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

import React, { useEffect, useRef } from 'react';
export var getDeprecatedMessage = function getDeprecatedMessage(message) {
  return "[DEPRECATED] ".concat(message);
};
export var deprecatedComponentWarning = function deprecatedComponentWarning(_ref) {
  var newComponentName = _ref.newComponentName,
    version = _ref.version,
    getMessage = _ref.getMessage;
  return function (Component) {
    var deprecatedComponentName = Component.displayName || Component.name;
    var DeprecatedWrapper = function DeprecatedWrapper(props) {
      useEffect(function () {
        var defaultMessage = version ? "".concat(deprecatedComponentName, " is deprecated in favor of ").concat(newComponentName, " and will be removed in v").concat(version, ".") : "".concat(deprecatedComponentName, " is deprecated in favor of ").concat(newComponentName, " and will be removed.");
        var message = (getMessage === null || getMessage === void 0 ? void 0 : getMessage(deprecatedComponentName)) || defaultMessage;
        var deprecatedMessage = getDeprecatedMessage(message);
        console.warn(deprecatedMessage);
      }, []);
      return /*#__PURE__*/React.createElement(Component, props);
    };
    Object.defineProperty(DeprecatedWrapper, 'name', {
      value: deprecatedComponentName
    });
    return DeprecatedWrapper;
  };
};
export var useDeprecatedPropWarning = function useDeprecatedPropWarning(_ref2) {
  var props = _ref2.props,
    version = _ref2.version,
    getMessage = _ref2.getMessage;
  var warnedProps = useRef(new Set()).current;
  useEffect(function () {
    Object.entries(props).forEach(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        name = _ref4[0],
        value = _ref4[1];
      if (value !== undefined && !warnedProps.has(name)) {
        var defaultMessage = version ? "The `".concat(name, "` prop is deprecated and will be removed in v").concat(version, ".") : "The `".concat(name, "` prop is deprecated and will be removed.");
        var message = (getMessage === null || getMessage === void 0 ? void 0 : getMessage(name)) || defaultMessage;
        var deprecatedMessage = getDeprecatedMessage(message);
        warnedProps.add(name);
        console.warn(deprecatedMessage);
      }
    });
  }, [warnedProps, props, version, getMessage]);
};