/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.NumericUtils;

public interface IndexSorter {
    public ComparableProvider[] getComparableProviders(List<? extends LeafReader> var1) throws IOException;

    public DocComparator getDocComparator(LeafReader var1, int var2) throws IOException;

    public String getProviderName();

    public static final class StringSorter
    implements IndexSorter {
        private final String providerName;
        private final Object missingValue;
        private final int reverseMul;
        private final SortedDocValuesProvider valuesProvider;

        public StringSorter(String providerName, Object missingValue, boolean reverse, SortedDocValuesProvider valuesProvider) {
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            SortedDocValues[] values = new SortedDocValues[readers.size()];
            for (int i = 0; i < readers.size(); ++i) {
                SortedDocValues sorted;
                values[i] = sorted = this.valuesProvider.get(readers.get(i));
            }
            OrdinalMap ordinalMap = OrdinalMap.build(null, values, 0.25f);
            int missingOrd = this.missingValue == SortField.STRING_LAST ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                SortedDocValues readerValues = values[readerIndex];
                LongValues globalOrds = ordinalMap.getGlobalOrds(readerIndex);
                providers[readerIndex] = docID -> {
                    if (readerValues.advanceExact(docID)) {
                        return globalOrds.get(readerValues.ordValue());
                    }
                    return missingOrd;
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            SortedDocValues sorted = this.valuesProvider.get(reader);
            int missingOrd = this.missingValue == SortField.STRING_LAST ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            int[] ords = new int[maxDoc];
            Arrays.fill(ords, missingOrd);
            while ((docID = sorted.nextDoc()) != Integer.MAX_VALUE) {
                ords[docID] = sorted.ordValue();
            }
            return (docID1, docID2) -> this.reverseMul * Integer.compare(ords[docID1], ords[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static final class DoubleSorter
    implements IndexSorter {
        private final String providerName;
        private final Double missingValue;
        private final int reverseMul;
        private final NumericDocValuesProvider valuesProvider;

        public DoubleSorter(String providerName, Double missingValue, boolean reverse, NumericDocValuesProvider valuesProvider) {
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            long missingValueBits = Double.doubleToLongBits(this.missingValue != null ? this.missingValue : 0.0);
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                NumericDocValues values = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = docID -> {
                    long valueBits = values.advanceExact(docID) ? values.longValue() : missingValueBits;
                    return NumericUtils.sortableDoubleBits(valueBits);
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            NumericDocValues dvs = this.valuesProvider.get(reader);
            double[] values = new double[maxDoc];
            if (this.missingValue != null) {
                Arrays.fill(values, this.missingValue);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values[docID] = Double.longBitsToDouble(dvs.longValue());
            }
            return (docID1, docID2) -> this.reverseMul * Double.compare(values[docID1], values[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static final class FloatSorter
    implements IndexSorter {
        private final String providerName;
        private final Float missingValue;
        private final int reverseMul;
        private final NumericDocValuesProvider valuesProvider;

        public FloatSorter(String providerName, Float missingValue, boolean reverse, NumericDocValuesProvider valuesProvider) {
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            int missValueBits = Float.floatToIntBits(this.missingValue != null ? this.missingValue.floatValue() : 0.0f);
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                NumericDocValues values = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = docID -> {
                    int valueBits = values.advanceExact(docID) ? (int)values.longValue() : missValueBits;
                    return NumericUtils.sortableFloatBits(valueBits);
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            NumericDocValues dvs = this.valuesProvider.get(reader);
            float[] values = new float[maxDoc];
            if (this.missingValue != null) {
                Arrays.fill(values, this.missingValue.floatValue());
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values[docID] = Float.intBitsToFloat((int)dvs.longValue());
            }
            return (docID1, docID2) -> this.reverseMul * Float.compare(values[docID1], values[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static final class LongSorter
    implements IndexSorter {
        private final String providerName;
        private final Long missingValue;
        private final int reverseMul;
        private final NumericDocValuesProvider valuesProvider;

        public LongSorter(String providerName, Long missingValue, boolean reverse, NumericDocValuesProvider valuesProvider) {
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            long missingValue = this.missingValue != null ? this.missingValue : 0L;
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                NumericDocValues values = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = docID -> {
                    if (values.advanceExact(docID)) {
                        return values.longValue();
                    }
                    return missingValue;
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            NumericDocValues dvs = this.valuesProvider.get(reader);
            long[] values = new long[maxDoc];
            if (this.missingValue != null) {
                Arrays.fill(values, this.missingValue);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values[docID] = dvs.longValue();
            }
            return (docID1, docID2) -> this.reverseMul * Long.compare(values[docID1], values[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static final class IntSorter
    implements IndexSorter {
        private final Integer missingValue;
        private final int reverseMul;
        private final NumericDocValuesProvider valuesProvider;
        private final String providerName;

        public IntSorter(String providerName, Integer missingValue, boolean reverse, NumericDocValuesProvider valuesProvider) {
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
            this.providerName = providerName;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            long missingValue = this.missingValue != null ? (long)this.missingValue.intValue() : 0L;
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                NumericDocValues values = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = docID -> {
                    if (values.advanceExact(docID)) {
                        return values.longValue();
                    }
                    return missingValue;
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            NumericDocValues dvs = this.valuesProvider.get(reader);
            int[] values = new int[maxDoc];
            if (this.missingValue != null) {
                Arrays.fill(values, this.missingValue);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values[docID] = (int)dvs.longValue();
            }
            return (docID1, docID2) -> this.reverseMul * Integer.compare(values[docID1], values[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static interface SortedDocValuesProvider {
        public SortedDocValues get(LeafReader var1) throws IOException;
    }

    public static interface NumericDocValuesProvider {
        public NumericDocValues get(LeafReader var1) throws IOException;
    }

    public static interface DocComparator {
        public int compare(int var1, int var2);
    }

    public static interface ComparableProvider {
        public long getAsComparableLong(int var1) throws IOException;
    }
}

