/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration;

import io.quarkus.runtime.Quarkus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.keycloak.platform.PlatformProvider;
import org.keycloak.quarkus.runtime.Environment;

public class QuarkusPlatform
implements PlatformProvider {
    private static final Logger log = Logger.getLogger(QuarkusPlatform.class);
    private AtomicBoolean started = new AtomicBoolean(false);
    private File tmpDir;

    public String name() {
        return "Quarkus";
    }

    public void exit(Throwable cause) {
        Quarkus.asyncExit((int)1);
    }

    public void started() {
        this.started.set(true);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public File getTmpDirectory() {
        if (this.tmpDir == null) {
            File tmpDir;
            String homeDir = Environment.getHomeDir();
            if (homeDir == null) {
                try {
                    File userDir;
                    String userDirProp;
                    String tmpDirProp = System.getProperty("java.io.tmpdir");
                    if ((tmpDirProp == null || !tmpDirProp.endsWith("target")) && (userDirProp = System.getProperty("user.dir")) != null && (userDir = new File(userDirProp, "target")).exists()) {
                        tmpDirProp = userDir.getAbsolutePath();
                    }
                    Path path = tmpDirProp != null ? Files.createTempDirectory(new File(tmpDirProp).toPath(), "keycloak-quarkus-tmp", new FileAttribute[0]) : Files.createTempDirectory("keycloak-quarkus-tmp", new FileAttribute[0]);
                    tmpDir = path.toFile();
                }
                catch (IOException ioex) {
                    throw new RuntimeException("It was not possible to create temporary directory keycloak-quarkus-tmp", ioex);
                }
            } else {
                String dataDir = Environment.getDataDir();
                tmpDir = new File(dataDir, "tmp");
                tmpDir.mkdirs();
            }
            if (tmpDir.isDirectory()) {
                this.tmpDir = tmpDir;
                log.debugf("Using server tmp directory: %s", (Object)tmpDir.getAbsolutePath());
            } else {
                throw new RuntimeException("Temporary directory " + tmpDir.getAbsolutePath() + " does not exist and it was not possible to create it.");
            }
        }
        return this.tmpDir;
    }
}

