/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ForwardingList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public class FailureMessages
extends ForwardingList<String> {
    private final List<String> failures;
    private final Optional<String> informationAboutNumberOfViolations;

    FailureMessages(ImmutableList<String> failures, Optional<String> informationAboutNumberOfViolations) {
        this.failures = failures;
        this.informationAboutNumberOfViolations = informationAboutNumberOfViolations;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getInformationAboutNumberOfViolations() {
        return this.informationAboutNumberOfViolations.orElse(this.failures.size() + " times");
    }

    FailureMessages filter(Predicate<String> predicate) {
        ImmutableList.Builder filtered = ImmutableList.builder();
        for (String message : this.failures) {
            if (!predicate.test(message)) continue;
            filtered.add(message);
        }
        return new FailureMessages((ImmutableList<String>)filtered.build(), this.informationAboutNumberOfViolations);
    }

    @Override
    protected List<String> delegate() {
        return this.failures;
    }
}

