/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.WindowItem;

class WindowDecoder {
    private WindowDecoder() {
    }

    static DockingWindow decodeWindow(ObjectInputStream in, ReadContext context) throws IOException {
        int id = in.readInt();
        switch (id) {
            case 1: {
                return View.read(in, context);
            }
            case 2: {
                SplitWindow w = new SplitWindow(true);
                return w.oldRead(in, context);
            }
            case 3: {
                TabWindow w = new TabWindow();
                return w.oldRead(in, context);
            }
        }
        throw new IOException("Invalid window ID: " + id + '!');
    }

    static DockingWindow decodeWindow(ObjectInputStream in, ReadContext context, ViewReader viewReader) throws IOException {
        int id = in.readInt();
        if (id == 1) {
            return viewReader.readView(in, context);
        }
        WindowItem windowItem = viewReader.readWindowItem(in, context);
        switch (id) {
            case 2: {
                SplitWindowItem item = (SplitWindowItem)windowItem;
                if (item == null) {
                    item = new SplitWindowItem();
                    item.readSettings(in, context);
                }
                SplitWindow w = new SplitWindow(item.isHorizontal(), item.getDividerLocation(), null, null, item);
                return w.newRead(in, context, viewReader);
            }
            case 3: {
                TabWindowItem item = (TabWindowItem)windowItem;
                if (item == null) {
                    item = new TabWindowItem();
                    item.readSettings(in, context);
                }
                TabWindow w = new TabWindow(null, item);
                return w.newRead(in, context, viewReader);
            }
        }
        throw new IOException("Invalid window ID: " + id + '!');
    }
}

