/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.ProjectArtifactFactory;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.ProjectArtifactsCache;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

@Named
public class LifecycleDependencyResolver {
    @Inject
    private ProjectDependenciesResolver dependenciesResolver;
    @Inject
    private Logger logger;
    @Inject
    private ProjectArtifactFactory artifactFactory;
    @Inject
    private EventSpyDispatcher eventSpyDispatcher;
    @Inject
    private ProjectArtifactsCache projectArtifactsCache;

    public LifecycleDependencyResolver() {
    }

    public LifecycleDependencyResolver(ProjectDependenciesResolver projectDependenciesResolver, Logger logger) {
        this.dependenciesResolver = projectDependenciesResolver;
        this.logger = logger;
    }

    public static List<MavenProject> getProjects(MavenProject project2, MavenSession session2, boolean aggregator) {
        if (aggregator && project2.getCollectedProjects() != null) {
            ArrayList<MavenProject> sortedProjects = new ArrayList<MavenProject>(session2.getProjects());
            ArrayList<MavenProject> projectAndSubmodules = new ArrayList<MavenProject>();
            LifecycleDependencyResolver.addProjectAndSubModules(projectAndSubmodules, project2);
            ListIterator sortedProjectsIterator = sortedProjects.listIterator();
            while (sortedProjectsIterator.hasNext()) {
                if (projectAndSubmodules.contains(sortedProjectsIterator.next())) continue;
                sortedProjectsIterator.remove();
            }
            return sortedProjects;
        }
        return Collections.singletonList(project2);
    }

    private static void addProjectAndSubModules(List<MavenProject> projects, MavenProject project2) {
        projects.add(project2);
        for (MavenProject submodule : project2.getCollectedProjects()) {
            LifecycleDependencyResolver.addProjectAndSubModules(projects, submodule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveProjectDependencies(MavenProject project2, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session2, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Set<org.apache.maven.artifact.Artifact> resolvedArtifacts;
            ProjectArtifactsCache.Key cacheKey;
            ProjectArtifactsCache.CacheRecord recordArtifacts;
            ClassRealm projectRealm = project2.getClassRealm();
            if (projectRealm != null && projectRealm != tccl) {
                Thread.currentThread().setContextClassLoader(projectRealm);
            }
            if (project2.getDependencyArtifacts() == null) {
                try {
                    project2.setDependencyArtifacts(this.artifactFactory.createArtifacts(project2));
                }
                catch (InvalidDependencyVersionException e2) {
                    throw new LifecycleExecutionException(e2);
                }
            }
            if ((recordArtifacts = this.projectArtifactsCache.get(cacheKey = this.projectArtifactsCache.createKey(project2, scopesToCollect, scopesToResolve, aggregating, session2.getRepositorySession()))) != null) {
                resolvedArtifacts = recordArtifacts.getArtifacts();
            } else {
                try {
                    resolvedArtifacts = this.getDependencies(project2, scopesToCollect, scopesToResolve, session2, aggregating, projectArtifacts);
                    recordArtifacts = this.projectArtifactsCache.put(cacheKey, resolvedArtifacts);
                }
                catch (LifecycleExecutionException e3) {
                    this.projectArtifactsCache.put(cacheKey, e3);
                    this.projectArtifactsCache.register(project2, cacheKey, recordArtifacts);
                    throw e3;
                }
            }
            this.projectArtifactsCache.register(project2, cacheKey, recordArtifacts);
            HashMap<org.apache.maven.artifact.Artifact, File> reactorProjects = new HashMap<org.apache.maven.artifact.Artifact, File>(session2.getProjects().size());
            for (MavenProject reactorProject : session2.getProjects()) {
                reactorProjects.put(reactorProject.getArtifact(), reactorProject.getArtifact().getFile());
            }
            HashMap<String, org.apache.maven.artifact.Artifact> map2 = new HashMap<String, org.apache.maven.artifact.Artifact>();
            for (org.apache.maven.artifact.Artifact artifact : resolvedArtifacts) {
                File reactorProjectFile = (File)reactorProjects.get(artifact);
                if (reactorProjectFile != null) {
                    artifact.setFile(reactorProjectFile);
                }
                map2.put(artifact.getDependencyConflictId(), artifact);
            }
            project2.setResolvedArtifacts(resolvedArtifacts);
            for (org.apache.maven.artifact.Artifact artifact : project2.getDependencyArtifacts()) {
                org.apache.maven.artifact.Artifact resolved;
                if (artifact.getFile() != null || (resolved = (org.apache.maven.artifact.Artifact)map2.get(artifact.getDependencyConflictId())) == null) continue;
                artifact.setFile(resolved.getFile());
                artifact.setDependencyTrail(resolved.getDependencyTrail());
                artifact.setResolvedVersion(resolved.getVersion());
                artifact.setResolved(true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private Set<org.apache.maven.artifact.Artifact> getDependencies(MavenProject project2, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session2, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        DependencyResolutionResult result;
        if (scopesToCollect == null) {
            scopesToCollect = Collections.emptySet();
        }
        if (scopesToResolve == null) {
            scopesToResolve = Collections.emptySet();
        }
        if (scopesToCollect.isEmpty() && scopesToResolve.isEmpty()) {
            return new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        }
        scopesToCollect = new HashSet<String>(scopesToCollect);
        scopesToCollect.addAll(scopesToResolve);
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(null, this.negate(scopesToCollect));
        DependencyFilter resolutionFilter = new ScopeDependencyFilter(null, this.negate(scopesToResolve));
        resolutionFilter = AndDependencyFilter.newInstance(collectionFilter, resolutionFilter);
        resolutionFilter = AndDependencyFilter.newInstance(resolutionFilter, new ReactorDependencyFilter(projectArtifacts));
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project2, session2.getRepositorySession());
            request.setResolutionFilter(resolutionFilter);
            this.eventSpyDispatcher.onEvent(request);
            result = this.dependenciesResolver.resolve(request);
        }
        catch (DependencyResolutionException e2) {
            result = e2.getResult();
            if (aggregating && this.areAllDependenciesInReactor(session2.getProjects(), result.getUnresolvedDependencies())) {
                this.logger.warn("The following dependencies could not be resolved at this point of the build but seem to be part of the reactor:");
                for (Dependency dependency : result.getUnresolvedDependencies()) {
                    this.logger.warn("o " + dependency);
                }
                this.logger.warn("Try running the build up to the lifecycle phase \"package\"");
            }
            throw new LifecycleExecutionException(null, project2, e2);
        }
        this.eventSpyDispatcher.onEvent(result);
        LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
            RepositoryUtils.toArtifacts(artifacts, result.getDependencyGraph().getChildren(), Collections.singletonList(project2.getArtifact().getId()), collectionFilter);
        }
        return artifacts;
    }

    private boolean areAllDependenciesInReactor(Collection<MavenProject> projects, Collection<Dependency> dependencies) {
        Set<String> projectKeys = this.getReactorProjectKeys(projects);
        for (Dependency dependency : dependencies) {
            Artifact a = dependency.getArtifact();
            String key2 = ArtifactUtils.key(a.getGroupId(), a.getArtifactId(), a.getVersion());
            if (projectKeys.contains(key2)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getReactorProjectKeys(Collection<MavenProject> projects) {
        HashSet<String> projectKeys = new HashSet<String>(projects.size() * 2);
        for (MavenProject project2 : projects) {
            String key2 = ArtifactUtils.key(project2.getGroupId(), project2.getArtifactId(), project2.getVersion());
            projectKeys.add(key2);
        }
        return projectKeys;
    }

    private Collection<String> negate(Collection<String> scopes) {
        HashSet<String> result = new HashSet<String>();
        Collections.addAll(result, "system", "compile", "provided", "runtime", "test");
        for (String scope : scopes) {
            if ("compile".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("provided");
                continue;
            }
            if ("runtime".equals(scope)) {
                result.remove("compile");
                result.remove("runtime");
                continue;
            }
            if ("compile+runtime".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("provided");
                result.remove("runtime");
                continue;
            }
            if ("runtime+system".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("runtime");
                continue;
            }
            if (!"test".equals(scope)) continue;
            result.clear();
        }
        return result;
    }

    private static class ReactorDependencyFilter
    implements DependencyFilter {
        private Set<String> keys = new HashSet<String>();

        ReactorDependencyFilter(Collection<org.apache.maven.artifact.Artifact> artifacts) {
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                String key2 = ArtifactUtils.key(artifact);
                this.keys.add(key2);
            }
        }

        @Override
        public boolean accept(DependencyNode node2, List<DependencyNode> parents2) {
            Dependency dependency = node2.getDependency();
            if (dependency != null) {
                Artifact a = dependency.getArtifact();
                String key2 = ArtifactUtils.key(a.getGroupId(), a.getArtifactId(), a.getVersion());
                return !this.keys.contains(key2);
            }
            return false;
        }
    }
}

