/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.jdbc.diagnostics.EncryptionStream;

final class SecureLogHandler
extends Handler {
    private X509Certificate certificate;
    private final String dumpFileLocation;
    private final String certFile;
    private final String certFilePwd;
    private EncryptionStream encStream;
    private final String loggerId;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    SecureLogHandler(String certFile, String certFilePwd, String dumpFileLocation, String loggerId) throws RuntimeException {
        this.certFilePwd = certFilePwd;
        this.certFile = certFile;
        this.dumpFileLocation = dumpFileLocation;
        this.loggerId = loggerId;
        this.doFilePermissionChecks();
        this.setFormatter(new SimpleFormatter());
        this.setFilter(record -> true);
    }

    void doFilePermissionChecks() throws RuntimeException {
        File dumpFolder = new File(this.dumpFileLocation);
        if (!dumpFolder.exists()) {
            throw new RuntimeException("Secure Log Initialization failed : Dump File Location " + this.dumpFileLocation + " does not exist.");
        }
        if (!dumpFolder.canWrite()) {
            throw new RuntimeException("Secure Log Initialization failed : Dump File Location " + this.dumpFileLocation + " does not have access to write.");
        }
        this.checkPublicAccess(this.dumpFileLocation);
        File certificateFile = new File(this.certFile);
        if (!certificateFile.exists()) {
            throw new RuntimeException("Secure Log Initialization failed : Certificate file " + this.certFile + " does not exist.");
        }
        try {
            this.certificate = this.getCertificate();
        }
        catch (Exception e2) {
            throw new RuntimeException("Secure Log Initialization failed : Invalid Certificate file : " + this.certFile, e2);
        }
        this.checkPublicAccess(this.certFile);
    }

    private boolean checkPublicAccess(String filePath) throws RuntimeException {
        return true;
    }

    private X509Certificate getCertificate() throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(new FileInputStream(this.certFile), this.certFilePwd.toCharArray());
        while (ks.aliases().hasMoreElements()) {
            Certificate cert = ks.getCertificate(ks.aliases().nextElement());
            if (!(cert instanceof X509Certificate)) continue;
            return (X509Certificate)cert;
        }
        throw new RuntimeException("Unable to retrive public key");
    }

    void initializeEncryptionStream() {
        String fileName = "alert_ojdbc_" + this.loggerId + "_" + System.currentTimeMillis() + ".log";
        try {
            this.encStream = EncryptionStream.newEncryptionStream(new FileOutputStream(this.dumpFileLocation + fileName), this.certificate);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.getFilter().isLoggable(record)) {
            return;
        }
        try {
            String debugMessage = this.getFormatter().format(record);
            this.encStream.write(debugMessage.getBytes());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void flush() {
        try {
            this.encStream.flush();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.encStream.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        if (newFormatter != null) {
            super.setFormatter(newFormatter);
        }
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        if (newFilter != null) {
            super.setFilter(newFilter);
        }
    }

    static {
        try {
            $$$methodRef$$$10 = SecureLogHandler.class.getDeclaredConstructor(String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SecureLogHandler.class.getDeclaredMethod("lambda$new$0", LogRecord.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SecureLogHandler.class.getDeclaredMethod("setFilter", Filter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SecureLogHandler.class.getDeclaredMethod("setFormatter", Formatter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SecureLogHandler.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SecureLogHandler.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SecureLogHandler.class.getDeclaredMethod("publish", LogRecord.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SecureLogHandler.class.getDeclaredMethod("initializeEncryptionStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SecureLogHandler.class.getDeclaredMethod("getCertificate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SecureLogHandler.class.getDeclaredMethod("checkPublicAccess", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SecureLogHandler.class.getDeclaredMethod("doFilePermissionChecks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

