from typing import Any

from django.contrib.gis.gdal.base import GDALBase

class Field(GDALBase):
    ptr: Any
    def __init__(self, feat: Any, index: Any) -> None: ...
    def as_double(self) -> float | None: ...
    def as_int(self, is_64: bool = ...) -> int | None: ...
    def as_string(self) -> str | None: ...
    def as_datetime(self) -> tuple[int, int, int, int, int, int, int] | None: ...
    @property
    def is_set(self) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def precision(self) -> int: ...
    @property
    def type(self) -> int: ...
    @property
    def type_name(self) -> bytes: ...
    @property
    def value(self) -> Any: ...
    @property
    def width(self) -> int: ...

class OFTInteger(Field):
    @property
    def value(self) -> Any: ...
    @property
    def type(self) -> Any: ...

class OFTReal(Field):
    @property
    def value(self) -> Any: ...

class OFTString(Field): ...
class OFTWideString(Field): ...
class OFTBinary(Field): ...

class OFTDate(Field):
    @property
    def value(self) -> Any: ...

class OFTDateTime(Field):
    @property
    def value(self) -> Any: ...

class OFTTime(Field):
    @property
    def value(self) -> Any: ...

class OFTInteger64(OFTInteger): ...
class OFTIntegerList(Field): ...
class OFTRealList(Field): ...
class OFTStringList(Field): ...
class OFTWideStringList(Field): ...
class OFTInteger64List(Field): ...

OGRFieldTypes: Any
ROGRFieldTypes: Any
