/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.Tools;

public class ConsistentApostrophesRule
extends TextLevelRule {
    public ConsistentApostrophesRule(ResourceBundle messages) {
        super(messages);
        this.setDefaultTempOff();
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/post/punctuation-guide/#what-is-an-apostrophe"));
        this.addExamplePair(Example.wrong((String)"It's nice, but it <marker>doesn\u2019t</marker> work."), Example.fixed((String)"It's nice, but it <marker>doesn't</marker> work."));
    }

    public String getId() {
        return "EN_CONSISTENT_APOS";
    }

    public String getDescription() {
        return "Checks if the two types of apostrophes (' and \u2019) are used consistently in a text.";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        int pos = 0;
        boolean hasTwoTypes = this.hasTwoApostropheTypes(sentences);
        if (!hasTwoTypes) {
            return this.toRuleMatchArray(matches);
        }
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens;
            for (AnalyzedTokenReadings token : tokens = sentence.getTokens()) {
                String message = null;
                String repl = null;
                if (token != null && token.getToken().contains("'") && !token.hasTypographicApostrophe()) {
                    message = "You used a typewriter-style apostrophe here, but a typographic apostrophe elsewhere in this text.";
                    repl = token.getToken().replace('\'', '\u2019');
                } else if (token != null && token.getToken().contains("'") && token.hasTypographicApostrophe()) {
                    message = "You used a typographic apostrophe here, but a typewriter-style apostrophe elsewhere in this text.";
                    repl = token.getToken();
                }
                if (message == null) continue;
                RuleMatch match = new RuleMatch((Rule)this, sentence, pos + token.getStartPos(), pos + token.getEndPos(), message + " Both are correct, but consider using the same type everywhere in your text.");
                match.setSuggestedReplacement(repl);
                matches.add(match);
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(matches);
    }

    private boolean hasTwoApostropheTypes(List<AnalyzedSentence> sentences) {
        boolean hasTypewriterStyle = false;
        boolean hasTypographicStyle = false;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens;
            for (AnalyzedTokenReadings token : tokens = sentence.getTokens()) {
                if (token != null && token.getToken().contains("'") && !token.hasTypographicApostrophe()) {
                    hasTypewriterStyle = true;
                } else if (token != null && token.getToken().contains("'") && token.hasTypographicApostrophe()) {
                    hasTypographicStyle = true;
                }
                if (!hasTypewriterStyle || !hasTypographicStyle) continue;
                return true;
            }
        }
        return false;
    }

    public int minToCheckParagraph() {
        return -1;
    }
}

