/*
 * Decompiled with CFR 0.152.
 */
package org.cef.security;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public final class CefX509Certificate {
    private X509Certificate[] chain_;

    public CefX509Certificate(byte[][] chainDERData) {
        this.chain_ = new X509Certificate[chainDERData.length];
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < chainDERData.length; ++i) {
                ByteArrayInputStream in = new ByteArrayInputStream(chainDERData[i]);
                this.chain_[i] = (X509Certificate)factory.generateCertificate(in);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.chain_ = null;
        }
    }

    public X509Certificate getSubjectCertificate() {
        if (this.chain_ == null || this.chain_.length == 0) {
            return null;
        }
        return this.chain_[0];
    }

    public X509Certificate[] getCertificatesChain() {
        return this.chain_;
    }
}

