/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.CharUtil;
import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AsciiApproximations
extends Rule {
    private static final Pattern parenthesizedNonC = Pattern.compile("\\([abd-z]\\)", 34);
    private static final Map<String, Pattern> exceptions = Map.of("-->", Pattern.compile("<!--.*-->", 32), "<=", Pattern.compile("<=\\s*(\\d|max|min|less)", 32), "(R)", Pattern.compile("\\([A-QS-Z]\\)", 32), "<-", Pattern.compile("<-.*>"), "c/o", Pattern.compile(".*www\\.[a-z/]+", 32));
    private static final Map<String, String> replacements = StreamEx.of(WordSet.loadLines("international/ascii-approximations.txt")).mapToEntry(s -> s.split(" ")[0], s -> s.split(" ")[1]).toMap();
    private static final String sameTokenChars = "<-=|>?";
    private static final Set<String> programmingTokens = Set.of("->", "=>", "<=");
    private static final AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();
    private static final NodePattern mightModifyWordStartingWithC = NodePattern.or(NodePattern.N.withHead("appos", NodePattern.N.form("c.+")), NodePattern.N.inFlatTree().after(NodePattern.N.form("c.+")));
    private final String msgFormat;

    public AsciiApproximations(Language language, String displayName, String description, String url, String msgFormat) {
        super("Typography.ASCII_APPROXIMATIONS", displayName, description, url, AsciiApproximations.arrowExample(language));
        this.msgFormat = msgFormat;
    }

    @Override
    public boolean supportsFlatTrees() {
        return true;
    }

    @Override
    @NotNull
    public MatchingResult match(Tree _tree) {
        Tree tree;
        Tree tree2 = tree = _tree.nodes().isEmpty() ? _tree.getFlatTree() : _tree;
        if (tree.nodes().isEmpty()) {
            return MatchingResult.EMPTY;
        }
        ArrayList result = new ArrayList();
        String text = tree.text();
        trie.parseText((CharSequence)text, (start, end, replacement) -> {
            if (start > 0 && CharUtil.isAnyOf(sameTokenChars, text.charAt(start - 1)) || end < text.length() && CharUtil.isAnyOf(sameTokenChars, text.charAt(end))) {
                return;
            }
            if (start > 0 && CharUtil.isAnyOf("'\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019", text.charAt(start - 1)) && end < text.length() && CharUtil.isAnyOf("'\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019", text.charAt(end))) {
                return;
            }
            String hit = text.substring(start, end);
            Pattern exception = exceptions.get(hit);
            if (exception != null && exception.matcher(text).find()) {
                return;
            }
            if (hit.equalsIgnoreCase("(c)") && !AsciiApproximations.allowCopyright(start, end, tree)) {
                return;
            }
            TextRange range = new TextRange(start, end);
            NodeMatch match = NodeMatch.EMPTY.withAnchor(tree.nodes().getFirst()).withMessage(this.msgFormat.formatted(replacement)).withCorrector(NodeCorrector.rawReplace(range, replacement).batchCapable("AsciiApproximation:" + hit)).withReportedRange(range, tree);
            if (!programmingTokens.contains(hit)) {
                match = match.enableAutoFix();
            }
            result.add(new NodeRuleMatch((Rule)this, match));
        });
        return MatchingResult.from(result);
    }

    private static boolean allowCopyright(int start, int end, Tree tree) {
        String text = tree.text();
        if (parenthesizedNonC.matcher(text).find()) {
            return false;
        }
        String before = text.substring(0, start).trim();
        if (before.isEmpty()) {
            return false;
        }
        if (before.toLowerCase(Locale.ROOT).endsWith("copyright")) {
            return true;
        }
        Node c = tree.findBestNodeAt(start + 1);
        if (mightModifyWordStartingWithC.matches(c)) {
            return false;
        }
        return !text.substring(end).isBlank();
    }

    private static Example arrowExample(Language language) {
        boolean cyrillic = language.getAlphabet().matchEntire((CharSequence)"\u0410");
        String x = cyrillic ? "\u0410" : "X";
        String y = cyrillic ? "\u0411" : "X";
        return new Example(x + "<b>-></b>" + y, x + "<b>\u2192</b>" + y);
    }

    static {
        trie.build(replacements);
    }
}

