/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.DataGridBundle;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.DateDelegate;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;

public final class ConverterSupport {
    private ConverterSupport() {
    }

    @NotNull
    public static Formatter createTimestampFormatter(@NotNull FormatterCreator formatterCreator) {
        if (formatterCreator == null) {
            ConverterSupport.$$$reportNull$$$0(0);
        }
        return new CompositeFormatter(DataGridBundle.message("expected.timestamp", new Object[0]), formatterCreator.newZonedTimestampFormat(new TimestampDelegate(), BoundaryValueResolver.ALWAYS_NULL, 6, null), formatterCreator.newIsoFormatter(new TimestampDelegate()));
    }

    @NotNull
    public static Formatter getTimeFormatter(@NotNull FormatterCreator formatterCreator) {
        if (formatterCreator == null) {
            ConverterSupport.$$$reportNull$$$0(1);
        }
        return new CompositeFormatter(DataGridBundle.message("expected.time", new Object[0]), formatterCreator.newZonedTimeFormat(new TimeDelegate(), 6, null), formatterCreator.newTimeFormat(null, 0, new TimeDelegate()));
    }

    @NotNull
    public static Formatter getDateFormatter(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        if (formatsCache == null) {
            ConverterSupport.$$$reportNull$$$0(2);
        }
        if (formatterCreator == null) {
            ConverterSupport.$$$reportNull$$$0(3);
        }
        Formatter formatter = formatterCreator.newEraDateFormatter(null, new DateDelegate(formatsCache, formatterCreator), BoundaryValueResolver.ALWAYS_NULL);
        if (formatter == null) {
            ConverterSupport.$$$reportNull$$$0(4);
        }
        return formatter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/ConverterSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/ConverterSupport";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTimestampFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTimeFormatter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormatter";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class TimestampDelegate
    extends DateAndTimeFormatterDelegate<TemporalAccessor, TemporalAccessor> {
        TimestampDelegate() {
            super(OffsetDateTime::from, temporal -> LocalDateTime.from(temporal).atOffset(DataGridFormattersUtilCore.getDefaultOffset()), temporal -> LocalDate.from(temporal).atStartOfDay().atOffset(DataGridFormattersUtilCore.getDefaultOffset()));
        }

        @Override
        protected TemporalAccessor toTemporalAccessor(@NotNull Object value) {
            if (value == null) {
                TimestampDelegate.$$$reportNull$$$0(0);
            }
            if (!(value instanceof TemporalAccessor)) {
                throw new IllegalArgumentException(String.format("Value class is not TemporalAccessor: %s", value.getClass()));
            }
            return value instanceof LocalDateTime ? ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(DataGridFormattersUtilCore.getDefaultOffset()) : (TemporalAccessor)value;
        }

        @Override
        protected TemporalAccessor createFromTemporal(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimestampDelegate.$$$reportNull$$$0(1);
            }
            return value instanceof ZonedDateTime ? ((ZonedDateTime)value).toOffsetDateTime() : value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/ConverterSupport$TimestampDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toTemporalAccessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromTemporal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TimeDelegate
    extends DateAndTimeFormatterDelegate<TemporalAccessor, TemporalAccessor> {
        TimeDelegate() {
            super(OffsetTime::from, temporal -> LocalTime.from(temporal).atOffset(DataGridFormattersUtilCore.getDefaultOffset()));
        }

        @Override
        protected TemporalAccessor toTemporalAccessor(@NotNull Object value) {
            if (value == null) {
                TimeDelegate.$$$reportNull$$$0(0);
            }
            if (value instanceof LocalTime) {
                LocalTime localTime = (LocalTime)value;
                return localTime.atOffset(DataGridFormattersUtilCore.getLocalTimeOffset()).withOffsetSameInstant(DataGridFormattersUtilCore.getDefaultOffset());
            }
            if (!(value instanceof TemporalAccessor)) {
                throw new IllegalArgumentException(String.format("Value class is not TemporalAccessor: %s", value.getClass()));
            }
            TemporalAccessor temporalAccessor = (TemporalAccessor)value;
            return temporalAccessor;
        }

        @Override
        protected TemporalAccessor createFromTemporal(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimeDelegate.$$$reportNull$$$0(1);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/ConverterSupport$TimeDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toTemporalAccessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromTemporal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

