/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regex;

import com.plantuml.ubrex.UMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.regex.RegexPartialMatch;

public class RegexResult {
    private final Map<String, RegexPartialMatch> data;
    private final UMatcher matcher;

    public RegexResult(Map<String, RegexPartialMatch> data) {
        this.data = Collections.unmodifiableMap(data);
        this.matcher = null;
    }

    public RegexResult(UMatcher matcher) {
        this.data = Collections.emptyMap();
        this.matcher = matcher;
    }

    public String toString() {
        if (this.matcher != null) {
            return this.matcher.toString();
        }
        return this.data.toString();
    }

    public RegexPartialMatch get(String key) {
        if (this.matcher != null) {
            throw new UnsupportedOperationException();
        }
        return this.data.get(key);
    }

    public String get(String key, int num) {
        if (this.matcher != null) {
            List<String> list = this.matcher.getCapture(key);
            if (list == null || list.size() == 0) {
                return null;
            }
            return list.get(num);
        }
        RegexPartialMatch reg = this.data.get(key);
        if (reg == null) {
            return null;
        }
        return reg.get(num);
    }

    public String getLazzy(String key, int num) {
        if (this.matcher != null) {
            for (String candidate : this.matcher.getKeysToBeRefactored()) {
                if (!candidate.startsWith(key)) continue;
                List<String> list = this.matcher.getCapture(candidate);
                if (list == null || list.size() == 0) {
                    return null;
                }
                return list.get(num);
            }
            return null;
        }
        for (Map.Entry<String, RegexPartialMatch> ent : this.data.entrySet()) {
            RegexPartialMatch match;
            if (!ent.getKey().startsWith(key) || num >= (match = ent.getValue()).size() || match.get(num) == null) continue;
            return ent.getValue().get(num);
        }
        return null;
    }

    public int size() {
        if (this.matcher != null) {
            throw new UnsupportedOperationException();
        }
        return this.data.size();
    }
}

