/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.ldap2;

import org.ldaptive.AddRequest;
import org.ldaptive.BindRequest;
import org.ldaptive.CompareRequest;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Response;
import org.ldaptive.SearchRequest;
import org.ldaptive.control.RequestControl;
import org.ldaptive.extended.ExtendedRequest;
import org.ldaptive.extended.UnsolicitedNotificationListener;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.SearchIterator;
import org.ldaptive.provider.SearchListener;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.opensearch.secure_sm.AccessController;

public class PrivilegedProvider
implements Provider<JndiProviderConfig> {
    private final Provider<JndiProviderConfig> delegate;

    public PrivilegedProvider(Provider<JndiProviderConfig> delegate) {
        this.delegate = delegate;
    }

    public JndiProviderConfig getProviderConfig() {
        return (JndiProviderConfig)this.delegate.getProviderConfig();
    }

    public void setProviderConfig(JndiProviderConfig pc) {
        this.delegate.setProviderConfig((ProviderConfig)pc);
    }

    public ProviderConnectionFactory<JndiProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        ProviderConnectionFactory connectionFactory = this.delegate.getConnectionFactory(cc);
        return new PrivilegedProviderConnectionFactory((ProviderConnectionFactory<JndiProviderConfig>)connectionFactory);
    }

    public Provider<JndiProviderConfig> newInstance() {
        return new PrivilegedProvider((Provider<JndiProviderConfig>)this.delegate.newInstance());
    }

    private static class PrivilegedProviderConnectionFactory
    implements ProviderConnectionFactory<JndiProviderConfig> {
        private final ProviderConnectionFactory<JndiProviderConfig> delegate;

        PrivilegedProviderConnectionFactory(ProviderConnectionFactory<JndiProviderConfig> delegate) {
            this.delegate = delegate;
        }

        public JndiProviderConfig getProviderConfig() {
            return (JndiProviderConfig)this.delegate.getProviderConfig();
        }

        public ProviderConnection create() throws LdapException {
            return (ProviderConnection)AccessController.doPrivilegedChecked(() -> new PrivilegedProviderConnection(this.delegate.create(), this.getProviderConfig()));
        }
    }

    private static class PrivilegedProviderConnection
    implements ProviderConnection {
        private final ProviderConnection delegate;
        private final JndiProviderConfig jndiProviderConfig;

        public PrivilegedProviderConnection(ProviderConnection delegate, JndiProviderConfig jndiProviderConfig) {
            this.delegate = delegate;
            this.jndiProviderConfig = jndiProviderConfig;
        }

        public Response<Void> bind(BindRequest request) throws LdapException {
            return (Response)AccessController.doPrivilegedChecked(() -> {
                if (this.jndiProviderConfig.getClassLoader() != null) {
                    ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.jndiProviderConfig.getClassLoader());
                        Response response = this.delegate.bind(request);
                        return response;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                    }
                }
                return this.delegate.bind(request);
            });
        }

        public Response<Void> add(AddRequest request) throws LdapException {
            return this.delegate.add(request);
        }

        public Response<Boolean> compare(CompareRequest request) throws LdapException {
            return this.delegate.compare(request);
        }

        public Response<Void> delete(DeleteRequest request) throws LdapException {
            return this.delegate.delete(request);
        }

        public Response<Void> modify(ModifyRequest request) throws LdapException {
            return this.delegate.modify(request);
        }

        public Response<Void> modifyDn(ModifyDnRequest request) throws LdapException {
            return this.delegate.modifyDn(request);
        }

        public SearchIterator search(SearchRequest request) throws LdapException {
            return this.delegate.search(request);
        }

        public void searchAsync(SearchRequest request, SearchListener listener) throws LdapException {
            this.delegate.searchAsync(request, listener);
        }

        public void abandon(int messageId, RequestControl[] controls) throws LdapException {
            this.delegate.abandon(messageId, controls);
        }

        public Response<?> extendedOperation(ExtendedRequest request) throws LdapException {
            return this.delegate.extendedOperation(request);
        }

        public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
            this.delegate.addUnsolicitedNotificationListener(listener);
        }

        public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
            this.delegate.removeUnsolicitedNotificationListener(listener);
        }

        public void close(RequestControl[] controls) throws LdapException {
            this.delegate.close(controls);
        }
    }
}

