/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.transform;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.translate.Transform;

public class Resize
implements Transform {
    private int width;
    private int height;
    private Image.Interpolation interpolation;

    public Resize(int size) {
        this(size, size, Image.Interpolation.BILINEAR);
    }

    public Resize(int width, int height) {
        this(width, height, Image.Interpolation.BILINEAR);
    }

    public Resize(int width, int height, Image.Interpolation interpolation) {
        this.width = width;
        this.height = height;
        this.interpolation = interpolation;
    }

    @Override
    public NDArray transform(NDArray array) {
        return NDImageUtils.resize(array, this.width, this.height, this.interpolation);
    }
}

