/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.EphemeralPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.model.PublicKeyDiscoveryInput;
import software.amazon.cryptography.materialproviders.model.RawPrivateKeyToStaticPublicKeyInput;

public class RawEcdhStaticConfigurations {
    private final PublicKeyDiscoveryInput PublicKeyDiscovery;
    private final RawPrivateKeyToStaticPublicKeyInput RawPrivateKeyToStaticPublicKey;
    private final EphemeralPrivateKeyToStaticPublicKeyInput EphemeralPrivateKeyToStaticPublicKey;

    protected RawEcdhStaticConfigurations(BuilderImpl builder) {
        this.PublicKeyDiscovery = builder.PublicKeyDiscovery();
        this.RawPrivateKeyToStaticPublicKey = builder.RawPrivateKeyToStaticPublicKey();
        this.EphemeralPrivateKeyToStaticPublicKey = builder.EphemeralPrivateKeyToStaticPublicKey();
    }

    public PublicKeyDiscoveryInput PublicKeyDiscovery() {
        return this.PublicKeyDiscovery;
    }

    public RawPrivateKeyToStaticPublicKeyInput RawPrivateKeyToStaticPublicKey() {
        return this.RawPrivateKeyToStaticPublicKey;
    }

    public EphemeralPrivateKeyToStaticPublicKeyInput EphemeralPrivateKeyToStaticPublicKey() {
        return this.EphemeralPrivateKeyToStaticPublicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected PublicKeyDiscoveryInput PublicKeyDiscovery;
        protected RawPrivateKeyToStaticPublicKeyInput RawPrivateKeyToStaticPublicKey;
        protected EphemeralPrivateKeyToStaticPublicKeyInput EphemeralPrivateKeyToStaticPublicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(RawEcdhStaticConfigurations model) {
            this.PublicKeyDiscovery = model.PublicKeyDiscovery();
            this.RawPrivateKeyToStaticPublicKey = model.RawPrivateKeyToStaticPublicKey();
            this.EphemeralPrivateKeyToStaticPublicKey = model.EphemeralPrivateKeyToStaticPublicKey();
        }

        @Override
        public Builder PublicKeyDiscovery(PublicKeyDiscoveryInput PublicKeyDiscovery) {
            this.PublicKeyDiscovery = PublicKeyDiscovery;
            return this;
        }

        @Override
        public PublicKeyDiscoveryInput PublicKeyDiscovery() {
            return this.PublicKeyDiscovery;
        }

        @Override
        public Builder RawPrivateKeyToStaticPublicKey(RawPrivateKeyToStaticPublicKeyInput RawPrivateKeyToStaticPublicKey) {
            this.RawPrivateKeyToStaticPublicKey = RawPrivateKeyToStaticPublicKey;
            return this;
        }

        @Override
        public RawPrivateKeyToStaticPublicKeyInput RawPrivateKeyToStaticPublicKey() {
            return this.RawPrivateKeyToStaticPublicKey;
        }

        @Override
        public Builder EphemeralPrivateKeyToStaticPublicKey(EphemeralPrivateKeyToStaticPublicKeyInput EphemeralPrivateKeyToStaticPublicKey) {
            this.EphemeralPrivateKeyToStaticPublicKey = EphemeralPrivateKeyToStaticPublicKey;
            return this;
        }

        @Override
        public EphemeralPrivateKeyToStaticPublicKeyInput EphemeralPrivateKeyToStaticPublicKey() {
            return this.EphemeralPrivateKeyToStaticPublicKey;
        }

        @Override
        public RawEcdhStaticConfigurations build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`RawEcdhStaticConfigurations` is a Union. A Union MUST have one and only one value set.");
            }
            return new RawEcdhStaticConfigurations(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.PublicKeyDiscovery, this.RawPrivateKeyToStaticPublicKey, this.EphemeralPrivateKeyToStaticPublicKey};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder PublicKeyDiscovery(PublicKeyDiscoveryInput var1);

        public PublicKeyDiscoveryInput PublicKeyDiscovery();

        public Builder RawPrivateKeyToStaticPublicKey(RawPrivateKeyToStaticPublicKeyInput var1);

        public RawPrivateKeyToStaticPublicKeyInput RawPrivateKeyToStaticPublicKey();

        public Builder EphemeralPrivateKeyToStaticPublicKey(EphemeralPrivateKeyToStaticPublicKeyInput var1);

        public EphemeralPrivateKeyToStaticPublicKeyInput EphemeralPrivateKeyToStaticPublicKey();

        public RawEcdhStaticConfigurations build();
    }
}

