/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.jsmpp.PDUStringException;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;

public class RandomDecimalMessageIDGenerator
implements MessageIDGenerator {
    private Random random;

    public RandomDecimalMessageIDGenerator() {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.random = new Random();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageId newMessageId() {
        try {
            Random random = this.random;
            synchronized (random) {
                return new MessageId(String.format("%010d", this.random.nextInt(Integer.MAX_VALUE)));
            }
        }
        catch (PDUStringException e) {
            throw new RuntimeException("Failed creating message id", e);
        }
    }
}

