/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import jakarta.ws.rs.core.UriInfo;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionManager;

public class UserConsentManager {
    public static boolean revokeConsentToClient(KeycloakSession session, ClientModel client, UserModel user) {
        RealmModel realm = session.getContext().getRealm();
        boolean revokedConsent = UserConsentManager.revokeConsentForClient(session, realm, user, client.getId());
        boolean revokedOfflineToken = new UserSessionManager(session).revokeOfflineToken(user, client);
        if (revokedConsent) {
            AuthenticationManager.backchannelLogoutUserFromClient(session, realm, user, client, (UriInfo)session.getContext().getUri(), session.getContext().getRequestHeaders());
        }
        return revokedConsent || revokedOfflineToken;
    }

    public static void addConsent(KeycloakSession session, RealmModel realm, UserModel user, UserConsentModel consent) {
        if (LightweightUserAdapter.isLightweightUser((UserModel)user)) {
            LightweightUserAdapter lua = (LightweightUserAdapter)user;
            lua.addConsent(consent);
        } else {
            session.users().addConsent(realm, user.getId(), consent);
        }
    }

    public static UserConsentModel getConsentByClient(KeycloakSession session, RealmModel realm, UserModel user, String clientInternalId) {
        if (LightweightUserAdapter.isLightweightUser((UserModel)user)) {
            LightweightUserAdapter lua = (LightweightUserAdapter)user;
            return lua.getConsentByClient(clientInternalId);
        }
        return session.users().getConsentByClient(realm, user.getId(), clientInternalId);
    }

    public static Stream<UserConsentModel> getConsentsStream(KeycloakSession session, RealmModel realm, UserModel user) {
        if (LightweightUserAdapter.isLightweightUser((UserModel)user)) {
            LightweightUserAdapter lua = (LightweightUserAdapter)user;
            return lua.getConsentsStream();
        }
        return session.users().getConsentsStream(realm, user.getId());
    }

    public static void updateConsent(KeycloakSession session, RealmModel realm, UserModel user, UserConsentModel consent) {
        if (LightweightUserAdapter.isLightweightUser((UserModel)user)) {
            LightweightUserAdapter lua = (LightweightUserAdapter)user;
            lua.updateConsent(consent);
        } else {
            session.users().updateConsent(realm, user.getId(), consent);
        }
    }

    public static boolean revokeConsentForClient(KeycloakSession session, RealmModel realm, UserModel user, String clientInternalId) {
        if (LightweightUserAdapter.isLightweightUser((UserModel)user)) {
            LightweightUserAdapter lua = (LightweightUserAdapter)user;
            return lua.revokeConsentForClient(clientInternalId);
        }
        return session.users().revokeConsentForClient(realm, user.getId(), clientInternalId);
    }
}

