/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;

public class UniMemoizeOp<I>
extends UniOperator<I, I>
implements UniSubscriber<I>,
ContextSupport {
    private UniSubscription currentUpstreamSubscription;
    private Context currentContext = Context.empty();
    private final BooleanSupplier invalidationRequested;
    private State state = State.INIT;
    private final ReentrantLock internalLock = new ReentrantLock();
    private final List<UniSubscriber<? super I>> awaiters = new ArrayList<UniSubscriber<? super I>>();
    private Object cachedResult = null;

    public UniMemoizeOp(Uni<? extends I> upstream) {
        this(upstream, () -> false);
    }

    public UniMemoizeOp(Uni<? extends I> upstream, BooleanSupplier invalidationRequested) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.invalidationRequested = invalidationRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        ParameterValidation.nonNull(subscriber, "subscriber");
        shouldSubscribeUpstream = false;
        cached = null;
        wasInCachingState = false;
        this.internalLock.lock();
        try {
            this.checkForInvalidation();
            switch (this.state.ordinal()) {
                case 0: {
                    this.state = State.WAITING_FOR_UPSTREAM;
                    this.awaiters.add(subscriber);
                    this.currentContext = subscriber.context();
                    shouldSubscribeUpstream = true;
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.awaiters.add(subscriber);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 2: {
                    cached = this.cachedResult;
                    wasInCachingState = true;
                    break;
                }
                ** default:
lbl28:
                // 1 sources

                break;
            }
        }
        finally {
            this.internalLock.unlock();
        }
        subscriber.onSubscribe(new MemoizedSubscription(subscriber));
        if (shouldSubscribeUpstream) {
            this.upstream().subscribe().withSubscriber(this);
        } else if (wasInCachingState) {
            this.forwardTo(subscriber, cached);
        }
    }

    private void checkForInvalidation() {
        if (this.invalidationRequested.getAsBoolean()) {
            this.state = State.INIT;
            if (this.currentUpstreamSubscription != null) {
                this.currentUpstreamSubscription.cancel();
                this.currentUpstreamSubscription = null;
            }
        }
    }

    @Override
    public void onSubscribe(UniSubscription subscription) {
        this.internalLock.lock();
        this.currentUpstreamSubscription = subscription;
        this.internalLock.unlock();
    }

    @Override
    public void onItem(I item) {
        this.internalLock.lock();
        List<UniSubscriber<? super I>> toNotify = null;
        if (this.state == State.WAITING_FOR_UPSTREAM) {
            this.state = State.CACHING;
            this.cachedResult = item;
            toNotify = this.gatherAwaiters();
        }
        this.internalLock.unlock();
        if (toNotify != null) {
            this.notifyAwaiters(toNotify, item);
        }
    }

    private List<UniSubscriber<? super I>> gatherAwaiters() {
        ArrayList<UniSubscriber<? super I>> copy = new ArrayList<UniSubscriber<? super I>>(this.awaiters);
        this.awaiters.clear();
        return copy;
    }

    private void notifyAwaiters(List<UniSubscriber<? super I>> toNotify, Object result) {
        Iterator<UniSubscriber<I>> iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            UniSubscriber<? super I> awaiter = iterator.next();
            this.forwardTo(awaiter, result);
            iterator.remove();
        }
    }

    @Override
    public void onFailure(Throwable failure) {
        this.internalLock.lock();
        List<UniSubscriber<? super I>> toNotify = null;
        if (this.state == State.WAITING_FOR_UPSTREAM) {
            this.state = State.CACHING;
            this.cachedResult = failure;
            toNotify = this.gatherAwaiters();
        }
        this.internalLock.unlock();
        if (toNotify != null) {
            this.notifyAwaiters(toNotify, failure);
        }
    }

    private void forwardTo(UniSubscriber<? super I> subscriber, Object result) {
        if (result instanceof Throwable) {
            subscriber.onFailure((Throwable)result);
        } else {
            subscriber.onItem(result);
        }
    }

    @Override
    public Context context() {
        return this.currentContext;
    }

    private static enum State {
        INIT,
        WAITING_FOR_UPSTREAM,
        CACHING;

    }

    private class MemoizedSubscription
    implements UniSubscription {
        private final UniSubscriber<? super I> subscriber;

        MemoizedSubscription(UniSubscriber<? super I> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void cancel() {
            UniMemoizeOp.this.internalLock.lock();
            try {
                UniMemoizeOp.this.awaiters.remove(this.subscriber);
            }
            finally {
                UniMemoizeOp.this.internalLock.unlock();
            }
        }
    }
}

