/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.serialization;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;

public class FixedEntityWriterArray
implements EntityWriter {
    private final MessageBodyWriter[] writers;
    private final ServerSerialisers serialisers;

    public FixedEntityWriterArray(MessageBodyWriter[] writers, ServerSerialisers serialisers) {
        this.writers = writers;
        this.serialisers = serialisers;
    }

    @Override
    public void write(ResteasyReactiveRequestContext context, Object entity) throws IOException {
        for (int i = 0; i < this.writers.length; ++i) {
            MessageBodyWriter writer = this.writers[i];
            if (!ServerSerialisers.invokeWriter(context, entity, writer, this.serialisers)) continue;
            return;
        }
        throw new InternalServerErrorException("Could not find MessageBodyWriter for " + String.valueOf(entity.getClass()), Response.serverError().build());
    }
}

